/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;
import java.util.ListIterator;

public final class LongEdgeJoiner
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Edge joining", 1.0f);
        this.joinLongEdges(layeredGraph);
        assert (this.noLongEdgeNodesRemaining(layeredGraph));
        monitor.done();
    }

    private void joinLongEdges(LGraph layeredGraph) {
        boolean addUnnecessaryBendpoints = layeredGraph.getProperty(LayeredOptions.UNNECESSARY_BENDPOINTS);
        for (Layer layer : layeredGraph) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                LongEdgeJoiner.joinAt(node, addUnnecessaryBendpoints);
                nodeIterator.remove();
            }
        }
    }

    public static void joinAt(LNode longEdgeDummy, boolean addUnnecessaryBendpoints) {
        List<LEdge> inputPortEdges = longEdgeDummy.getPorts(PortSide.WEST).iterator().next().getIncomingEdges();
        List<LEdge> outputPortEdges = longEdgeDummy.getPorts(PortSide.EAST).iterator().next().getOutgoingEdges();
        int edgeCount = inputPortEdges.size();
        KVector unnecessaryBendpoint = longEdgeDummy.getPorts().get(0).getAbsoluteAnchor();
        while (edgeCount-- > 0) {
            LEdge survivingEdge = inputPortEdges.get(0);
            LEdge droppedEdge = outputPortEdges.get(0);
            List<LEdge> targetIncomingEdges = droppedEdge.getTarget().getIncomingEdges();
            int droppedEdgeListIndex = targetIncomingEdges.indexOf(droppedEdge);
            survivingEdge.setTargetAndInsertAtIndex(droppedEdge.getTarget(), droppedEdgeListIndex);
            droppedEdge.setSource(null);
            droppedEdge.setTarget(null);
            KVectorChain survivingBendPoints = survivingEdge.getBendPoints();
            if (addUnnecessaryBendpoints) {
                survivingBendPoints.add(new KVector(unnecessaryBendpoint));
            }
            for (KVector bendPoint : droppedEdge.getBendPoints()) {
                survivingBendPoints.add(new KVector(bendPoint));
            }
            List<LLabel> survivingLabels = survivingEdge.getLabels();
            for (LLabel label : droppedEdge.getLabels()) {
                survivingLabels.add(label);
            }
            KVectorChain survivingJunctionPoints = survivingEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
            KVectorChain droppedJunctionsPoints = droppedEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
            if (droppedJunctionsPoints == null) continue;
            if (survivingJunctionPoints == null) {
                survivingJunctionPoints = new KVectorChain();
                survivingEdge.setProperty(LayeredOptions.JUNCTION_POINTS, survivingJunctionPoints);
            }
            for (KVector jp : droppedJunctionsPoints) {
                survivingJunctionPoints.add(new KVector(jp));
            }
        }
    }

    private boolean noLongEdgeNodesRemaining(LGraph layeredGraph) {
        return layeredGraph.getNodesFromAllLayers().stream().noneMatch(node -> node.getType() == LNode.NodeType.LONG_EDGE);
    }
}

