/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.labels.ILabelManager;
import com.modelengineers.MoRe_elk.core.labels.LabelManagementOptions;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;

public final class LabelManagementProcessor
implements ILayoutProcessor<LGraph> {
    private static final double MIN_WIDTH_PORT_LABELS = 20.0;
    private static final double MIN_WIDTH_NODE_LABELS = 40.0;
    public static final double MIN_WIDTH_EDGE_LABELS = 60.0;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label management", 1.0f);
        ILabelManager labelManager = layeredGraph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        if (labelManager != null) {
            double labelLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
            this.manageLabels(layeredGraph, labelManager, labelLabelSpacing);
        }
        monitor.done();
    }

    private void manageLabels(LGraph lGraph, ILabelManager labelManager, double labelLabelSpacing) {
        for (Layer layer : lGraph) {
            for (LNode node : layer) {
                if (node.getType() == LNode.NodeType.NORMAL) {
                    LabelManagementProcessor.doManageLabels(labelManager, node.getLabels(), 40.0, labelLabelSpacing);
                    List<LPort> ports = node.getPorts();
                    for (LPort port : ports) {
                        LabelManagementProcessor.doManageLabels(labelManager, port.getLabels(), 20.0, labelLabelSpacing);
                    }
                    if (node.hasProperty(InternalProperties.TOP_COMMENTS)) {
                        this.doManageAttachedCommentLabels(labelManager, node.getProperty(InternalProperties.TOP_COMMENTS), 40.0);
                    }
                    if (node.hasProperty(InternalProperties.BOTTOM_COMMENTS)) {
                        this.doManageAttachedCommentLabels(labelManager, node.getProperty(InternalProperties.BOTTOM_COMMENTS), 40.0);
                    }
                }
                for (LEdge edge : node.getOutgoingEdges()) {
                    LabelManagementProcessor.doManageLabels(labelManager, edge.getLabels(), 60.0, 0.0);
                }
            }
        }
    }

    private void doManageAttachedCommentLabels(ILabelManager labelManager, List<LNode> commentNodes, double minWidthNodeLabels) {
        for (LNode commentNode : commentNodes) {
            if (commentNode.getLabels().isEmpty()) continue;
            LabelManagementProcessor.doManageLabels(labelManager, commentNode.getLabels(), minWidthNodeLabels, 0.0);
        }
    }

    public static KVector doManageLabels(ILabelManager labelManager, Iterable<LLabel> labels, double targetWidth, double labelLabelSpacing) {
        KVector requiredLabelSpace = new KVector();
        if (labels.iterator().hasNext()) {
            for (LLabel label : labels) {
                KVector newSize;
                KVector labelSize = label.getSize();
                Object origin = label.getProperty(InternalProperties.ORIGIN);
                if (origin != null && (newSize = labelManager.manageLabelSize(origin, targetWidth)) != null) {
                    labelSize.x = newSize.x;
                    labelSize.y = newSize.y;
                }
                requiredLabelSpace.x = Math.max(requiredLabelSpace.x, labelSize.x);
                requiredLabelSpace.y += labelLabelSpacing + label.getSize().y;
            }
            requiredLabelSpace.y -= labelLabelSpacing;
        }
        return requiredLabelSpace;
    }
}

