/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InLayerConstraint;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;

public final class InLayerConstraintProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer constraint edge reversal", 1.0f);
        for (Layer layer : layeredGraph) {
            int topInsertionIndex = -1;
            ArrayList bottomConstrainedNodes = Lists.newArrayList();
            LNode[] nodes = LGraphUtil.toNodeArray(layer.getNodes());
            int i = 0;
            while (i < nodes.length) {
                InLayerConstraint constraint = nodes[i].getProperty(InternalProperties.IN_LAYER_CONSTRAINT);
                if (topInsertionIndex == -1) {
                    if (constraint != InLayerConstraint.TOP) {
                        topInsertionIndex = i;
                    }
                } else if (constraint == InLayerConstraint.TOP) {
                    nodes[i].setLayer(null);
                    nodes[i].setLayer(topInsertionIndex++, layer);
                }
                if (constraint == InLayerConstraint.BOTTOM) {
                    bottomConstrainedNodes.add(nodes[i]);
                }
                ++i;
            }
            for (LNode node : bottomConstrainedNodes) {
                node.setLayer(null);
                node.setLayer(layer);
            }
        }
        monitor.done();
    }
}

