/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.HorizontalLabelAlignment;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.LabelCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.VerticalLabelAlignment;
import com.modelengineers.MoRe_elk.alg.common.overlaps.RectangleStripOverlapRemover;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphAdapters;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.ElkMargin;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.LabelSide;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class EndLabelPreprocessor
implements ILayoutProcessor<LGraph> {
    private static HashMap<LNode, ElkMargin> nodeMarginsBeforeEndLabelPreprocessor = new HashMap();
    private static final double NO_INCIDENT_EDGE_THICKNESS = -1.0;

    public HashMap<LNode, ElkMargin> getNodeMarginsBeforeEndLabelPreprocessor() {
        return nodeMarginsBeforeEndLabelPreprocessor;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label pre-processing", 1.0f);
        double edgeLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
        double labelLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).forEach(node -> this.processNode((LNode)node, edgeLabelSpacing, labelLabelSpacing));
        monitor.done();
    }

    private void processNode(LNode node, double edgeLabelSpacing, double labelLabelSpacing) {
        int portCount = node.getPorts().size();
        LabelCell[] portLabelCells = new LabelCell[portCount];
        int portIndex = 0;
        while (portIndex < portCount) {
            LPort port = node.getPorts().get(portIndex);
            port.id = portIndex;
            portLabelCells[portIndex] = this.createConfiguredLabelCell(EndLabelPreprocessor.gatherLabels(port), labelLabelSpacing);
            ++portIndex;
        }
        this.placeLabels(node, portLabelCells, labelLabelSpacing, edgeLabelSpacing);
        HashMap<LPort, LabelCell> portToLabelCellMap = new HashMap<LPort, LabelCell>();
        int index = 0;
        while (index < portLabelCells.length) {
            if (portLabelCells[index] != null) {
                portToLabelCellMap.put(node.getPorts().get(index), portLabelCells[index]);
            }
            ++index;
        }
        if (!portToLabelCellMap.isEmpty()) {
            node.setProperty(InternalProperties.END_LABELS, portToLabelCellMap);
            this.updateNodeMargins(node, portLabelCells);
        }
    }

    private LabelCell createConfiguredLabelCell(List<LLabel> labels, double labelLabelSpacing) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        LabelCell labelCell = new LabelCell(labelLabelSpacing, true);
        for (LLabel label : labels) {
            labelCell.addLabel(LGraphAdapters.adapt(label));
        }
        ElkRectangle labelCellRect = labelCell.getCellRectangle();
        labelCellRect.height = labelCell.getMinimumHeight();
        labelCellRect.width = labelCell.getMinimumWidth();
        return labelCell;
    }

    static List<LLabel> gatherLabels(LPort port) {
        ArrayList labels = Lists.newArrayList();
        double maxEdgeThickness = EndLabelPreprocessor.gatherLabels(port, labels);
        LNode dummyNode = port.getProperty(InternalProperties.PORT_DUMMY);
        if (dummyNode != null) {
            for (LPort dummyPort : dummyNode.getPorts()) {
                if (dummyPort.getProperty(InternalProperties.ORIGIN) != port) continue;
                maxEdgeThickness = Math.max(maxEdgeThickness, EndLabelPreprocessor.gatherLabels(dummyPort, labels));
            }
        }
        if (!labels.isEmpty()) {
            port.setProperty(InternalProperties.MAX_EDGE_THICKNESS, (Object)maxEdgeThickness);
        }
        return maxEdgeThickness != -1.0 ? labels : null;
    }

    private static double gatherLabels(LPort port, List<LLabel> targetList) {
        double maxEdgeThickness = -1.0;
        LinkedList labels = new LinkedList();
        for (LEdge incidentEdge : port.getConnectedEdges()) {
            maxEdgeThickness = Math.max(maxEdgeThickness, incidentEdge.getProperty(LayeredOptions.EDGE_THICKNESS));
            if (incidentEdge.getSource() == port) {
                incidentEdge.getLabels().stream().filter(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.TAIL).forEach(label -> {
                    boolean bl = labels.add(label);
                });
            } else {
                incidentEdge.getLabels().stream().filter(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.HEAD).forEach(label -> {
                    boolean bl = labels.add(label);
                });
            }
            for (LLabel label2 : labels) {
                if (label2.hasProperty(InternalProperties.END_LABEL_EDGE)) continue;
                label2.setProperty(InternalProperties.END_LABEL_EDGE, incidentEdge);
            }
            targetList.addAll(labels);
            labels.clear();
        }
        return maxEdgeThickness;
    }

    private void placeLabels(LNode node, LabelCell[] portLabelCells, double labelLabelSpacing, double edgeLabelSpacing) {
        EnumSet<PortSide> portSidesWithLabels = EnumSet.noneOf(PortSide.class);
        for (LPort port : node.getPorts()) {
            if (portLabelCells[port.id] == null) continue;
            this.placeLabels(port, portLabelCells[port.id], edgeLabelSpacing);
            portSidesWithLabels.add(port.getSide());
        }
        this.removeLabelOverlaps(node, portLabelCells, PortSide.NORTH, 2.0 * labelLabelSpacing, edgeLabelSpacing);
        this.removeLabelOverlaps(node, portLabelCells, PortSide.SOUTH, 2.0 * labelLabelSpacing, edgeLabelSpacing);
    }

    private void placeLabels(LPort port, LabelCell labelCell, double edgeLabelSpacing) {
        ElkRectangle labelCellRect = labelCell.getCellRectangle();
        KVector nodeSize = port.getNode().getSize();
        LMargin nodeMargin = port.getNode().getMargin();
        KVector portPos = port.getPosition();
        KVector portAnchor = KVector.sum(portPos, port.getAnchor());
        switch (port.getSide()) {
            case NORTH: {
                labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                labelCellRect.y = -nodeMargin.top - edgeLabelSpacing - labelCellRect.height;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    labelCellRect.x = portAnchor.x - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.width;
                    break;
                }
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = portAnchor.x + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case EAST: {
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = nodeSize.x + nodeMargin.right + edgeLabelSpacing;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    labelCellRect.y = portAnchor.y - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.height;
                    break;
                }
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = portAnchor.y + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case SOUTH: {
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = nodeSize.y + nodeMargin.bottom + edgeLabelSpacing;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    labelCellRect.x = portAnchor.x - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.width;
                    break;
                }
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = portAnchor.x + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case WEST: {
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                labelCellRect.x = -nodeMargin.left - edgeLabelSpacing - labelCellRect.width;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    labelCellRect.y = portAnchor.y - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.height;
                    break;
                }
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = portAnchor.y + this.maxEdgeThickness(port) + edgeLabelSpacing;
            }
        }
    }

    private void removeLabelOverlaps(LNode node, LabelCell[] portLabelCells, PortSide portSide, double labelLabelSpacing, double edgeLabelSpacing) {
        RectangleStripOverlapRemover overlapRemover = RectangleStripOverlapRemover.createForDirection(this.portSideToOverlapRemovalDirection(portSide)).withGap(labelLabelSpacing, labelLabelSpacing).withStartCoordinate(this.calculateOverlapStartCoordinate(node, portSide, edgeLabelSpacing));
        for (LPort port : node.getPorts(portSide)) {
            if (portLabelCells[port.id] == null) continue;
            ElkRectangle labelCellRect = portLabelCells[port.id].getCellRectangle();
            assert (labelCellRect.height > 0.0 && labelCellRect.width > 0.0);
            overlapRemover.addRectangle(labelCellRect);
        }
        overlapRemover.removeOverlaps();
    }

    private double calculateOverlapStartCoordinate(LNode node, PortSide portSide, double edgeLabelSpacing) {
        KVector nodeSize = node.getSize();
        LMargin nodeMargin = node.getMargin();
        switch (portSide) {
            case NORTH: {
                return -nodeMargin.top - edgeLabelSpacing;
            }
            case SOUTH: {
                return nodeSize.y + nodeMargin.bottom + edgeLabelSpacing;
            }
            case EAST: {
                return nodeSize.x + nodeMargin.right + edgeLabelSpacing;
            }
            case WEST: {
                return -nodeMargin.left - edgeLabelSpacing;
            }
        }
        assert (false);
        return 0.0;
    }

    private void updateNodeMargins(LNode node, LabelCell[] labelCells) {
        LMargin nodeMargin = node.getMargin();
        nodeMarginsBeforeEndLabelPreprocessor.put(node, nodeMargin.clone());
        KVector nodeSize = node.getSize();
        ElkRectangle nodeMarginRectangle = new ElkRectangle(-nodeMargin.left, -nodeMargin.top, nodeMargin.left + nodeSize.x + nodeMargin.right, nodeMargin.top + nodeSize.y + nodeMargin.bottom);
        LabelCell[] labelCellArray = labelCells;
        int n = labelCells.length;
        int n2 = 0;
        while (n2 < n) {
            LabelCell labelCell = labelCellArray[n2];
            if (labelCell != null) {
                nodeMarginRectangle.union(labelCell.getCellRectangle());
            }
            ++n2;
        }
        nodeMargin.left = -nodeMarginRectangle.x;
        nodeMargin.top = -nodeMarginRectangle.y;
        nodeMargin.right = nodeMarginRectangle.width - nodeMargin.left - nodeSize.x;
        nodeMargin.bottom = nodeMarginRectangle.height - nodeMargin.top - nodeSize.y;
    }

    private LabelSide getLabelSide(LabelCell labelCell) {
        assert (labelCell != null);
        assert (labelCell.hasLabels());
        return labelCell.getLabels().get(0).getProperty(InternalProperties.LABEL_SIDE);
    }

    private double maxEdgeThickness(LPort port) {
        return port.getProperty(InternalProperties.MAX_EDGE_THICKNESS);
    }

    private RectangleStripOverlapRemover.OverlapRemovalDirection portSideToOverlapRemovalDirection(PortSide portSide) {
        switch (portSide) {
            case NORTH: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.UP;
            }
            case SOUTH: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.DOWN;
            }
            case EAST: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.RIGHT;
            }
            case WEST: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.LEFT;
            }
        }
        assert (false);
        return null;
    }
}

