/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph.transform;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.NodeLabelAndSizeCalculator;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.CrossingMinimizationStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredSpacings;
import com.modelengineers.MoRe_elk.alg.layered.options.NodePlacementStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.UnsupportedGraphException;
import com.modelengineers.MoRe_elk.core.labels.LabelManagementOptions;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.HierarchyHandling;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.adapters.ElkGraphAdapters;
import com.modelengineers.MoRe_elk.graph.ElkBendPoint;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import com.modelengineers.MoRe_emf.ecore.util.EcoreUtil;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ElkGraphImporter {
    private final Map<ElkGraphElement, LGraphElement> nodeAndPortMap = Maps.newHashMap();

    public LGraph importGraph(ElkNode elkgraph) {
        LGraph topLevelGraph = this.createLGraph(elkgraph);
        elkgraph.getPorts().stream().forEach(elkport -> this.ensureDefinedPortSide(topLevelGraph, (ElkPort)elkport));
        Set<GraphProperties> graphProperties = topLevelGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        this.checkExternalPorts(elkgraph, graphProperties);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (ElkPort elkport2 : elkgraph.getPorts()) {
                this.transformExternalPort(elkgraph, topLevelGraph, elkport2);
            }
        }
        if (this.shouldCalculateMinimumGraphSize(elkgraph)) {
            this.calculateMinimumGraphSize(elkgraph, topLevelGraph);
        }
        if (topLevelGraph.hasProperty(LayeredOptions.SPACING_BASE_VALUE)) {
            LayeredSpacings.withBaseValue(topLevelGraph.getProperty(LayeredOptions.SPACING_BASE_VALUE)).apply(topLevelGraph);
        }
        if (elkgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.importHierarchicalGraph(elkgraph, topLevelGraph);
        } else {
            this.importFlatGraph(elkgraph, topLevelGraph);
        }
        return topLevelGraph;
    }

    private void ensureDefinedPortSide(LGraph lgraph, ElkPort elkport) {
        PortSide portSide = elkport.getProperty(LayeredOptions.PORT_SIDE);
        PortConstraints portConstraints = lgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isSideFixed()) {
            int netFlow = this.calculateNetFlow(elkport);
            portSide = netFlow > 0 ? PortSide.EAST : PortSide.WEST;
        } else if (portSide == PortSide.UNDEFINED && (portSide = ElkUtil.calcPortSide(elkport)) == PortSide.UNDEFINED) {
            portSide = PortSide.EAST;
        }
        elkport.setProperty(LayeredOptions.PORT_SIDE, portSide);
    }

    private boolean shouldCalculateMinimumGraphSize(ElkNode elkgraph) {
        return !elkgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).isEmpty();
    }

    private void calculateMinimumGraphSize(ElkNode elkgraph, LGraph lgraph) {
        if (elkgraph.getParent() == null) {
            return;
        }
        EnumSet<SizeConstraint> sizeConstraints = lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        assert (!sizeConstraints.isEmpty());
        if (elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.UNDEFINED) {
            elkgraph.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
        ElkGraphAdapters.ElkGraphAdapter graphAdapter = ElkGraphAdapters.adapt(elkgraph.getParent());
        ElkGraphAdapters.ElkNodeAdapter nodeAdapter = ElkGraphAdapters.adaptSingleNode(elkgraph);
        KVector minSize = NodeLabelAndSizeCalculator.process(graphAdapter, nodeAdapter, false, true);
        sizeConstraints.add(SizeConstraint.MINIMUM_SIZE);
        KVector configuredMinSize = lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
        configuredMinSize.x = Math.max(minSize.x, configuredMinSize.x);
        configuredMinSize.y = Math.max(minSize.y, configuredMinSize.y);
    }

    private void importFlatGraph(ElkNode elkgraph, LGraph lgraph) {
        ElkNode source;
        for (ElkNode child : elkgraph.getChildren()) {
            if (child.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
            this.transformNode(child, lgraph);
        }
        for (ElkEdge elkedge : elkgraph.getContainedEdges()) {
            source = ElkGraphUtil.getSourceNode(elkedge);
            ElkNode target = ElkGraphUtil.getTargetNode(elkedge);
            boolean enableInsideSelfLoops = source.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
            boolean isToBeLaidOut = elkedge.getProperty(LayeredOptions.NO_LAYOUT) == false;
            boolean isInsideSelfLoop = enableInsideSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            boolean connectsSiblings = source.getParent() == elkgraph && source.getParent() == target.getParent();
            boolean connectsToGraph = (source.getParent() == elkgraph && target == elkgraph) ^ (target.getParent() == elkgraph && source == elkgraph);
            if (!isToBeLaidOut || isInsideSelfLoop || !connectsToGraph && !connectsSiblings) continue;
            this.transformEdge(elkedge, elkgraph, lgraph);
        }
        if (elkgraph.getParent() != null) {
            for (ElkEdge elkedge : elkgraph.getParent().getContainedEdges()) {
                boolean isInsideSelfLoop;
                source = ElkGraphUtil.getSourceNode(elkedge);
                if (source != elkgraph || !elkedge.isSelfloop()) continue;
                boolean bl = isInsideSelfLoop = source.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                if (!isInsideSelfLoop) continue;
                this.transformEdge(elkedge, elkgraph, lgraph);
            }
        }
    }

    private void importHierarchicalGraph(ElkNode elkgraph, LGraph lgraph) {
        LNode parentLNode;
        LGraph parentLGraph;
        LinkedList elkGraphQueue = Lists.newLinkedList();
        elkGraphQueue.addAll(elkgraph.getChildren());
        while (!elkGraphQueue.isEmpty()) {
            boolean isNodeToBeLaidOut;
            ElkNode elknode = (ElkNode)elkGraphQueue.poll();
            boolean bl = isNodeToBeLaidOut = elknode.getProperty(LayeredOptions.NO_LAYOUT) == false;
            if (!isNodeToBeLaidOut) continue;
            boolean hasChildren = !elknode.getChildren().isEmpty();
            boolean hasInsideSelfLoops = this.hasInsideSelfLoops(elknode);
            boolean hasHierarchyHandlingEnabled = elknode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            boolean usesElkLayered = !elknode.hasProperty(CoreOptions.ALGORITHM) || elknode.getProperty(CoreOptions.ALGORITHM).equals("com.modelengineers.MoRe_elk.layered");
            LGraph nestedGraph = null;
            if (usesElkLayered && hasHierarchyHandlingEnabled && (hasChildren || hasInsideSelfLoops)) {
                nestedGraph = this.createLGraph(elknode);
                if (nestedGraph.hasProperty(LayeredOptions.SPACING_BASE_VALUE)) {
                    LayeredSpacings.withBaseValue(nestedGraph.getProperty(LayeredOptions.SPACING_BASE_VALUE)).apply(nestedGraph);
                }
                if (this.shouldCalculateMinimumGraphSize(elknode)) {
                    LGraph finalNestedGraph = nestedGraph;
                    elknode.getPorts().stream().forEach(elkport -> this.ensureDefinedPortSide(finalNestedGraph, (ElkPort)elkport));
                    this.calculateMinimumGraphSize(elknode, nestedGraph);
                }
            }
            parentLGraph = lgraph;
            parentLNode = (LNode)this.nodeAndPortMap.get(elknode.getParent());
            if (parentLNode != null) {
                parentLGraph = parentLNode.getNestedGraph();
            }
            LNode lnode = this.transformNode(elknode, parentLGraph);
            if (nestedGraph == null) continue;
            lnode.setNestedGraph(nestedGraph);
            nestedGraph.setParentNode(lnode);
            elkGraphQueue.addAll(elknode.getChildren());
        }
        elkGraphQueue.add(elkgraph);
        while (!elkGraphQueue.isEmpty()) {
            boolean hasHierarchyHandlingEnabled;
            ElkNode elkGraphNode = (ElkNode)elkGraphQueue.poll();
            for (ElkEdge elkedge : elkGraphNode.getContainedEdges()) {
                this.checkEdgeValidity(elkedge);
                ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getSources().get(0));
                ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
                if (elkedge.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || sourceNode.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || targetNode.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
                boolean isInsideSelfLoop = elkedge.isSelfloop() && sourceNode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                ElkNode parentElkGraph = elkGraphNode;
                if (isInsideSelfLoop || ElkGraphUtil.isDescendant(targetNode, sourceNode)) {
                    parentElkGraph = sourceNode;
                } else if (ElkGraphUtil.isDescendant(sourceNode, targetNode)) {
                    parentElkGraph = targetNode;
                }
                parentLGraph = lgraph;
                parentLNode = (LNode)this.nodeAndPortMap.get(parentElkGraph);
                if (parentLNode != null) {
                    parentLGraph = parentLNode.getNestedGraph();
                }
                LEdge ledge = this.transformEdge(elkedge, parentElkGraph, parentLGraph);
                ledge.setProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN, this.findCoordinateSystemOrigin(elkedge, elkgraph, lgraph));
            }
            boolean bl = hasHierarchyHandlingEnabled = elkGraphNode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            if (!hasHierarchyHandlingEnabled) continue;
            for (ElkNode elkChildGraphNode : elkGraphNode.getChildren()) {
                boolean partOfSameLayoutRun;
                boolean usesElkLayered = !elkChildGraphNode.hasProperty(CoreOptions.ALGORITHM) || elkChildGraphNode.getProperty(CoreOptions.ALGORITHM).equals("com.modelengineers.MoRe_elk.layered");
                boolean bl2 = partOfSameLayoutRun = elkChildGraphNode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
                if (!usesElkLayered || !partOfSameLayoutRun) continue;
                elkGraphQueue.add(elkChildGraphNode);
            }
        }
    }

    private boolean hasInsideSelfLoops(ElkNode elknode) {
        if (elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges(elknode)) {
                if (!edge.isSelfloop() || !edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private LGraph findCoordinateSystemOrigin(ElkEdge elkedge, ElkNode topLevelElkGraph, LGraph topLevelLGraph) {
        LGraph lgraph;
        ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getSources().get(0));
        ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0));
        if (source.getParent() == target.getParent()) {
            return null;
        }
        if (ElkGraphUtil.isDescendant(target, source)) {
            return null;
        }
        ElkNode origin = elkedge.getContainingNode();
        assert (source == origin || ElkGraphUtil.isDescendant(source, origin));
        assert (target == origin || ElkGraphUtil.isDescendant(target, origin));
        if (origin == topLevelElkGraph) {
            return topLevelLGraph;
        }
        LNode lnode = (LNode)this.nodeAndPortMap.get(origin);
        if (lnode != null && (lgraph = lnode.getNestedGraph()) != null) {
            return lgraph;
        }
        return null;
    }

    private LGraph createLGraph(ElkNode elkgraph) {
        LGraph lgraph = new LGraph();
        lgraph.copyProperties(elkgraph);
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) == null) {
            ElkGraphElement root = (ElkGraphElement)EcoreUtil.getRootContainer(elkgraph);
            lgraph.setProperty(LabelManagementOptions.LABEL_MANAGER, root.getProperty(LabelManagementOptions.LABEL_MANAGER));
        }
        lgraph.setProperty(InternalProperties.ORIGIN, elkgraph);
        lgraph.setProperty(InternalProperties.GRAPH_PROPERTIES, EnumSet.noneOf(GraphProperties.class));
        ElkPadding nodeLabelpadding = NodeLabelAndSizeCalculator.computeInsideNodeLabelPadding(elkgraph.getParent() == null ? null : ElkGraphAdapters.adapt(elkgraph.getParent()), ElkGraphAdapters.adaptSingleNode(elkgraph));
        ElkPadding nodePadding = lgraph.getProperty(LayeredOptions.PADDING);
        LPadding lPadding = lgraph.getPadding();
        lPadding.add(nodePadding);
        lPadding.add(nodeLabelpadding);
        return lgraph;
    }

    private void checkExternalPorts(ElkNode elkgraph, Set<GraphProperties> graphProperties) {
        boolean enableSelfLoops = elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        Set portLabelPlacement = elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
        boolean hasExternalPorts = false;
        boolean hasHyperedges = false;
        Iterator portIterator = elkgraph.getPorts().iterator();
        while (!(!portIterator.hasNext() || hasExternalPorts && hasHyperedges)) {
            ElkPort elkport = (ElkPort)portIterator.next();
            int externalPortEdges = 0;
            for (ElkEdge elkedge : ElkGraphUtil.allIncidentEdges(elkport)) {
                boolean connectsToChild;
                boolean isInsideSelfLoop;
                boolean bl = isInsideSelfLoop = enableSelfLoops && elkedge.isSelfloop() && elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                boolean bl2 = elkedge.getSources().contains(elkport) ? elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getTargets().get(0)).getParent() : (connectsToChild = elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkedge.getSources().get(0)).getParent());
                if ((isInsideSelfLoop || connectsToChild) && ++externalPortEdges > 1) break;
            }
            if (externalPortEdges > 0) {
                hasExternalPorts = true;
            } else if (portLabelPlacement.contains((Object)PortLabelPlacement.INSIDE) && elkport.getLabels().size() > 0) {
                hasExternalPorts = true;
            }
            if (externalPortEdges <= 1) continue;
            hasHyperedges = true;
        }
        if (hasExternalPorts) {
            graphProperties.add(GraphProperties.EXTERNAL_PORTS);
        }
        if (hasHyperedges) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
    }

    private void transformExternalPort(ElkNode elkgraph, LGraph lgraph, ElkPort elkport) {
        KVector elkportPosition = new KVector(elkport.getX() + elkport.getWidth() / 2.0, elkport.getY() + elkport.getHeight() / 2.0);
        int netFlow = this.calculateNetFlow(elkport);
        PortConstraints portConstraints = elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        PortSide portSide = elkport.getProperty(LayeredOptions.PORT_SIDE);
        assert (portSide != PortSide.UNDEFINED);
        if (!elkport.getAllProperties().containsKey(LayeredOptions.PORT_BORDER_OFFSET)) {
            double portOffset = elkport.getX() == 0.0 && elkport.getY() == 0.0 ? 0.0 : ElkUtil.calcPortOffset(elkport, portSide);
            elkport.setProperty(LayeredOptions.PORT_BORDER_OFFSET, portOffset);
        }
        KVector graphSize = new KVector(elkgraph.getWidth(), elkgraph.getHeight());
        LNode dummy = LGraphUtil.createExternalPortDummy(elkport, portConstraints, portSide, netFlow, graphSize, elkportPosition, new KVector(elkport.getWidth(), elkport.getHeight()), lgraph);
        dummy.setProperty(InternalProperties.ORIGIN, elkport);
        LPort dummyPort = dummy.getPorts().get(0);
        dummyPort.setConnectedToExternalNodes(this.isConnectedToExternalNodes(elkport));
        dummy.setProperty(LayeredOptions.PORT_LABELS_PLACEMENT, PortLabelPlacement.outside());
        boolean insidePortLabels = elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT).contains((Object)PortLabelPlacement.INSIDE);
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            dummyPort.getLabels().add(llabel);
            if (insidePortLabels) continue;
            double insidePart = 0.0;
            if (PortLabelPlacement.isFixed((Set<PortLabelPlacement>)elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT))) {
                insidePart = ElkUtil.computeInsidePart(new KVector(elklabel.getX(), elklabel.getY()), new KVector(elklabel.getWidth(), elklabel.getHeight()), new KVector(elkport.getWidth(), elkport.getHeight()), 0.0, portSide);
            }
            switch (portSide) {
                case EAST: 
                case WEST: {
                    llabel.getSize().x = insidePart;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    llabel.getSize().y = insidePart;
                }
            }
        }
        dummy.setProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL, elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL));
        dummy.setProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL, elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL));
        dummy.setProperty(LayeredOptions.SPACING_LABEL_LABEL, elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_LABEL));
        lgraph.getLayerlessNodes().add(dummy);
        this.nodeAndPortMap.put(elkport, dummy);
    }

    private int calculateNetFlow(ElkPort elkport) {
        boolean isInsideSelfLoop;
        boolean isSelfLoop;
        ElkNode elkgraph = elkport.getParent();
        boolean insideSelfLoopsEnabled = elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        int outputPortVote = 0;
        int inputPortVote = 0;
        for (ElkEdge outgoingEdge : elkport.getOutgoingEdges()) {
            isSelfLoop = outgoingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && outgoingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)outgoingEdge.getTargets().get(0));
            if (isSelfLoop && isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (targetNode.getParent() == elkgraph || targetNode == elkgraph) {
                ++inputPortVote;
                continue;
            }
            ++outputPortVote;
        }
        for (ElkEdge incomingEdge : elkport.getIncomingEdges()) {
            isSelfLoop = incomingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && incomingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)incomingEdge.getSources().get(0));
            if (isSelfLoop && isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (sourceNode.getParent() == elkgraph || sourceNode == elkgraph) {
                ++outputPortVote;
                continue;
            }
            ++inputPortVote;
        }
        return outputPortVote - inputPortVote;
    }

    private boolean isConnectedToExternalNodes(ElkPort elkport) {
        ElkNode parent = elkport.getParent();
        for (ElkEdge outEdge : elkport.getOutgoingEdges()) {
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)outEdge.getTargets().get(0));
            if (ElkGraphUtil.isDescendant(targetNode, parent)) continue;
            return true;
        }
        for (ElkEdge inEdge : elkport.getIncomingEdges()) {
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)inEdge.getSources().get(0));
            if (ElkGraphUtil.isDescendant(sourceNode, parent)) continue;
            return true;
        }
        return false;
    }

    private LNode transformNode(ElkNode elknode, LGraph lgraph) {
        LNode lnode = new LNode(lgraph);
        lnode.copyProperties(elknode);
        lnode.setProperty(InternalProperties.ORIGIN, elknode);
        lnode.getSize().x = elknode.getWidth();
        lnode.getSize().y = elknode.getHeight();
        lnode.getPosition().x = elknode.getX();
        lnode.getPosition().y = elknode.getY();
        lgraph.getLayerlessNodes().add(lnode);
        this.nodeAndPortMap.put(elknode, lnode);
        if (!elknode.getChildren().isEmpty() || elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            lnode.setProperty(InternalProperties.COMPOUND_NODE, (Object)true);
        }
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        PortConstraints portConstraints = lnode.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            lnode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        } else if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        for (ElkPort elkport : elknode.getPorts()) {
            if (elkport.getProperty(LayeredOptions.NO_LAYOUT).booleanValue()) continue;
            this.transformPort(elkport, lnode, graphProperties, portConstraints);
        }
        for (ElkLabel elklabel : elknode.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lnode.getLabels().add(this.transformLabel(elklabel));
        }
        if (lnode.getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        return lnode;
    }

    private LPort transformPort(ElkPort elkport, LNode parentLNode, Set<GraphProperties> graphProperties, PortConstraints portConstraints) {
        LPort lport = new LPort();
        lport.copyProperties(elkport);
        lport.setSide(elkport.getProperty(LayeredOptions.PORT_SIDE));
        lport.setProperty(InternalProperties.ORIGIN, elkport);
        lport.setNode(parentLNode);
        KVector portSize = lport.getSize();
        portSize.x = elkport.getWidth();
        portSize.y = elkport.getHeight();
        KVector portPos = lport.getPosition();
        portPos.x = elkport.getX();
        portPos.y = elkport.getY();
        this.nodeAndPortMap.put(elkport, lport);
        boolean connectionsToDescendants = elkport.getOutgoingEdges().stream().flatMap(edge -> edge.getTargets().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(targetNode -> ElkGraphUtil.isDescendant(targetNode, elkport.getParent()));
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getIncomingEdges().stream().flatMap(edge -> edge.getSources().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(sourceNode -> ElkGraphUtil.isDescendant(sourceNode, elkport.getParent()));
        }
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getOutgoingEdges().stream().anyMatch(edge -> edge.isSelfloop() && edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false);
        }
        lport.setProperty(InternalProperties.INSIDE_CONNECTIONS, (Object)connectionsToDescendants);
        LGraphUtil.initializePort(lport, portConstraints, elkport.getProperty(LayeredOptions.PORT_ANCHOR));
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lport.getLabels().add(this.transformLabel(elklabel));
        }
        if (lport.getSide() == PortSide.NORTH || lport.getSide() == PortSide.SOUTH) {
            graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
        }
        return lport;
    }

    private LEdge transformEdge(ElkEdge elkedge, ElkNode elkparent, LGraph lgraph) {
        boolean bendPointsRequired;
        PortType portType;
        this.checkEdgeValidity(elkedge);
        ElkConnectableShape elkSourceShape = (ElkConnectableShape)elkedge.getSources().get(0);
        ElkConnectableShape elkTargetShape = (ElkConnectableShape)elkedge.getTargets().get(0);
        ElkNode elkSourceNode = ElkGraphUtil.connectableShapeToNode(elkSourceShape);
        ElkNode elkTargetNode = ElkGraphUtil.connectableShapeToNode(elkTargetShape);
        ElkEdgeSection edgeSection = elkedge.getSections().isEmpty() ? null : (ElkEdgeSection)elkedge.getSections().get(0);
        LNode sourceLNode = (LNode)this.nodeAndPortMap.get(elkSourceNode);
        LNode targetLNode = (LNode)this.nodeAndPortMap.get(elkTargetNode);
        LPort sourceLPort = null;
        LPort targetLPort = null;
        if (elkSourceShape instanceof ElkPort) {
            LGraphElement sourceElem = this.nodeAndPortMap.get(elkSourceShape);
            if (sourceElem instanceof LPort) {
                sourceLPort = (LPort)sourceElem;
            } else if (sourceElem instanceof LNode) {
                sourceLNode = (LNode)sourceElem;
                sourceLPort = sourceLNode.getPorts().get(0);
            }
        }
        if (elkTargetShape instanceof ElkPort) {
            LGraphElement targetElem = this.nodeAndPortMap.get(elkTargetShape);
            if (targetElem instanceof LPort) {
                targetLPort = (LPort)targetElem;
            } else if (targetElem instanceof LNode) {
                targetLNode = (LNode)targetElem;
                targetLPort = targetLNode.getPorts().get(0);
            }
        }
        if (sourceLNode == null || targetLNode == null) {
            throw new UnsupportedGraphException("The source or the target of edge " + elkedge + " could not be found. " + "This usually happens when an edge connects a node laid out by ELK Layered to a node in " + "another level of hierarchy laid out by either another instance of ELK Layered or another " + "layout algorithm alltogether. The former can be solved by setting the hierarchyHandling " + "option to INCLUDE_CHILDREN.");
        }
        LEdge ledge = new LEdge();
        ledge.copyProperties(elkedge);
        ledge.setProperty(InternalProperties.ORIGIN, elkedge);
        ledge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (sourceLNode == targetLNode) {
            graphProperties.add(GraphProperties.SELF_LOOPS);
        }
        if (sourceLPort == null) {
            portType = PortType.OUTPUT;
            KVector sourcePoint = null;
            if (edgeSection != null && sourceLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
                sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
                ElkUtil.toAbsolute(sourcePoint, elkedge.getContainingNode());
                ElkUtil.toRelative(sourcePoint, elkparent);
                if (ElkGraphUtil.isDescendant(elkTargetNode, elkSourceNode)) {
                    portType = PortType.INPUT;
                    sourcePoint.add(sourceLNode.getPosition());
                }
            }
            sourceLPort = LGraphUtil.createPort(sourceLNode, sourcePoint, portType, lgraph);
        }
        if (targetLPort == null) {
            portType = PortType.INPUT;
            Object targetPoint = null;
            if (edgeSection != null && targetLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
                targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
                ElkUtil.toAbsolute((KVector)targetPoint, elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)targetPoint, elkparent);
            }
            targetLPort = LGraphUtil.createPort(targetLNode, targetPoint, portType, targetLNode.getGraph());
        }
        ledge.setSource(sourceLPort);
        ledge.setTarget(targetLPort);
        if (sourceLPort.getIncomingEdges().size() > 1 || sourceLPort.getOutgoingEdges().size() > 1 || targetLPort.getIncomingEdges().size() > 1 || targetLPort.getOutgoingEdges().size() > 1) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        for (ElkLabel elklabel : elkedge.getLabels()) {
            if (elklabel.getProperty(LayeredOptions.NO_LAYOUT).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            ledge.getLabels().add(llabel);
            switch (llabel.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT)) {
                case HEAD: 
                case TAIL: {
                    graphProperties.add(GraphProperties.END_LABELS);
                }
            }
        }
        CrossingMinimizationStrategy crossMinStrat = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY);
        NodePlacementStrategy nodePlaceStrat = lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY);
        boolean bl = bendPointsRequired = crossMinStrat == CrossingMinimizationStrategy.INTERACTIVE || nodePlaceStrat == NodePlacementStrategy.INTERACTIVE;
        if (edgeSection != null && !edgeSection.getBendPoints().isEmpty() && bendPointsRequired) {
            KVectorChain originalBendpoints = this.getBendPoints(edgeSection);
            ledge.setProperty(InternalProperties.ORIGINAL_BENDPOINTS, originalBendpoints);
        }
        return ledge;
    }

    private KVectorChain getBendPoints(ElkEdgeSection edgeSection) {
        KVectorChain chain = new KVectorChain();
        for (ElkBendPoint bendPoint : edgeSection.getBendPoints()) {
            chain.add(new KVector(bendPoint.getX(), bendPoint.getY()));
        }
        return chain;
    }

    private void checkEdgeValidity(ElkEdge edge) {
        if (edge.getSources().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a source.");
        }
        if (edge.getTargets().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a target.");
        }
        if (edge.isHyperedge()) {
            throw new UnsupportedGraphException("Hyperedges are not supported.");
        }
    }

    private LLabel transformLabel(ElkLabel elklabel) {
        LLabel newLabel = new LLabel(elklabel.getText());
        newLabel.copyProperties(elklabel);
        newLabel.setProperty(InternalProperties.ORIGIN, elklabel);
        newLabel.getSize().x = elklabel.getWidth();
        newLabel.getSize().y = elklabel.getHeight();
        newLabel.getPosition().x = elklabel.getX();
        newLabel.getPosition().y = elklabel.getY();
        return newLabel;
    }
}

