/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.core.math.KVector;
import java.util.Iterator;
import java.util.List;

public final class Layer
extends LGraphElement
implements Iterable<LNode> {
    private static final long serialVersionUID = 5760328884701318753L;
    private final LGraph owner;
    private final KVector size = new KVector();
    private final List<LNode> nodes = Lists.newArrayList();

    public Layer(LGraph graph) {
        this.owner = graph;
    }

    public KVector getSize() {
        return this.size;
    }

    public List<LNode> getNodes() {
        return this.nodes;
    }

    public LNode getFirstNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(0);
    }

    public LNode getLastNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public Iterator<LNode> iterator() {
        return this.nodes.iterator();
    }

    public LGraph getGraph() {
        return this.owner;
    }

    public int getIndex() {
        return this.owner.getLayers().indexOf(this);
    }

    public Layer getNextLayer(boolean forward) {
        int index = this.getIndex();
        List<Layer> layers = this.owner.getLayers();
        if (forward) {
            return index < layers.size() - 1 ? layers.get(index + 1) : null;
        }
        return index > 0 ? layers.get(index - 1) : null;
    }

    public String toString() {
        return "L_" + this.getIndex() + this.nodes.toString();
    }
}

