/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.alg.layered.graph.Component;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.LShape;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayerConstraint;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.MesBlockParametersMap;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.impl.ElkNodeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class LNode
extends LShape {
    private static final long serialVersionUID = -4272570519129722541L;
    private LGraph graph;
    private Layer layer;
    private Component component;
    private NodeType type = NodeType.NORMAL;
    private final List<LPort> ports = Lists.newArrayListWithCapacity((int)6);
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)2);
    private LGraph nestedGraph;
    private final LMargin margin = new LMargin();
    private final LPadding padding = new LPadding();
    private EnumMap<PortSide, Pair<Integer, Integer>> portSideIndices;
    private boolean portSidesCached = false;
    private LNode originalWideNode;
    private List<LNode> wideNodeDummies;
    private LMargin labelMargin = new LMargin();
    private boolean isSingleFlippedNodeInFeedbackLoop = false;
    private double heightAdjustment = 0.0;

    public LNode(LGraph graph) {
        this.graph = graph;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public double getHeightAdjustment() {
        return this.heightAdjustment;
    }

    public void adjustTrueHeight(double newHeight) {
        LNode originalNode;
        double heightDiff = newHeight - this.getTrueHeightWithoutLabelMargins();
        if (this.isWideNode()) {
            this.getWideNodeDummies().forEach(d2 -> {
                double d3 = d2.getSize().y = d2.getSize().y + heightDiff;
            });
            originalNode = this.getOriginalWideNode();
        } else {
            originalNode = this;
        }
        originalNode.getSize().y += heightDiff;
        originalNode.heightAdjustment = heightDiff;
        originalNode.setProperty(InternalProperties.HEIGHT_WAS_ADJUSTED, (Object)true);
    }

    public double getTrueHeightWithoutLabelMargins() {
        LMargin trueLabelMargin = this.getTrueLabelMargin();
        return this.getTrueSize().y - trueLabelMargin.bottom - trueLabelMargin.top;
    }

    public KVector getTrueSize() {
        return this.isWideNode() ? this.getOriginalWideNode().getSize() : this.getSize();
    }

    private LMargin getTrueLabelMargin() {
        return this.isWideNode() ? this.getOriginalWideNode().getLabelMargin() : this.getLabelMargin();
    }

    public double getTopTopDistanceToLowerNeighbor() {
        return this.getLowerNeighbor().getPosition().y - this.getPosition().y;
    }

    public double getPreferredTopTopDistanceToLowerNeighbor() {
        LNode lowerNeighbor = this.getLowerNeighbor();
        double preferredNodeNodeDistance = this.getGraph().getProperty(InternalProperties.SPACINGS).getVerticalSpacing(this, lowerNeighbor);
        return this.getTopTopDistanceToLowerNeighbor(lowerNeighbor, preferredNodeNodeDistance);
    }

    public double getMinTopTopDistanceToLowerNeighbor() {
        if (this.canHaveZeroDistanceToLowerNeighbor()) {
            return 0.0;
        }
        double minNodeNodeDistance = this.getGraph().getProperty(LayeredOptions.SPACING_MIN_NODE_NODE_Y);
        return this.getTopTopDistanceToLowerNeighbor(this.getLowerNeighbor(), minNodeNodeDistance);
    }

    public boolean canHaveZeroDistanceToLowerNeighbor() {
        LNode lowerNeighbor = this.getLowerNeighbor();
        return LNode.canHaveNoTopTopDistanceToEachOther(this, lowerNeighbor);
    }

    private static boolean canHaveNoTopTopDistanceToEachOther(LNode n1, LNode n2) {
        return n1 != null && n2 != null && n1.isLongEdgeOrNorthSouthDummy() && n2.isLongEdgeOrNorthSouthDummy() && LNode.haveSameSourceOrTargetSkippingLongEdges(n1, n2);
    }

    private static boolean haveSameSourceOrTargetSkippingLongEdges(LNode n1, LNode n2) {
        return LNode.connectedToSamePortSkippingLongEdges(n1, n2, true) || LNode.connectedToSamePortSkippingLongEdges(n1, n2, false);
    }

    private static boolean connectedToSamePortSkippingLongEdges(LNode n1, LNode n2, boolean forward) {
        LPort s1 = LNode.getPortSkippingLongEdges(n1, forward);
        LPort s2 = LNode.getPortSkippingLongEdges(n2, forward);
        return s1 != null && s1 == s2;
    }

    private static LPort getPortSkippingLongEdges(LNode node, boolean forward) {
        List<LEdge> edges = node.getEdges(forward);
        return edges.isEmpty() ? null : edges.get(0).getPortSkippingLongEdges(forward);
    }

    private double getTopTopDistanceToLowerNeighbor(LNode lowerNeighbor, double nodeNodeDistance) {
        return this.getSize().y + this.getMargin().bottom + nodeNodeDistance + lowerNeighbor.getMargin().top;
    }

    public void setLayer(Layer thelayer) {
        if (this.layer != null) {
            this.layer.getNodes().remove(this);
        }
        this.layer = thelayer;
        if (this.layer != null) {
            this.layer.getNodes().add(this);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component thecomponent) {
        if (this.component != null) {
            this.component.getNodes().remove(this);
        }
        this.component = thecomponent;
        if (this.component != null) {
            this.component.getNodes().add(this);
        }
    }

    public LGraph getGraph() {
        if (this.graph == null && this.layer != null) {
            return this.layer.getGraph();
        }
        return this.graph;
    }

    public void setGraph(LGraph newGraph) {
        assert (this.layer == null);
        this.graph = newGraph;
    }

    public void setLayer(int index, Layer newlayer) {
        if (newlayer != null && (index < 0 || index > newlayer.getNodes().size())) {
            throw new IllegalArgumentException("index must be >= 0 and <= layer node count");
        }
        if (this.layer != null) {
            this.layer.getNodes().remove(this);
        }
        this.layer = newlayer;
        if (newlayer != null) {
            newlayer.getNodes().add(index, this);
        }
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public boolean isNormal() {
        return this.getType() == NodeType.NORMAL;
    }

    public boolean isLongEdge() {
        return this.getType() == NodeType.LONG_EDGE;
    }

    public boolean isLongEdgeOrNorthSouthDummy() {
        return this.isLongEdge() || this.isNorthSouthDummy();
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public Iterable<LPort> getPorts(PortType portType) {
        switch (portType) {
            case INPUT: {
                return Iterables.filter(this.ports, LPort.INPUT_PREDICATE);
            }
            case OUTPUT: {
                return Iterables.filter(this.ports, LPort.OUTPUT_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public List<LPort> getPortsAsList(PortType portType) {
        return MesUtilMethods.iterableToList(this.getPorts(portType));
    }

    public Iterable<LPort> getPorts(PortSide side) {
        switch (side) {
            case NORTH: {
                return Iterables.filter(this.ports, LPort.NORTH_PREDICATE);
            }
            case EAST: {
                return Iterables.filter(this.ports, LPort.EAST_PREDICATE);
            }
            case SOUTH: {
                return Iterables.filter(this.ports, LPort.SOUTH_PREDICATE);
            }
            case WEST: {
                return Iterables.filter(this.ports, LPort.WEST_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public List<LPort> getPortsAsList(PortSide side) {
        return MesUtilMethods.iterableToList(this.getPorts(side));
    }

    public List<LPort> getTruePortsSortedTopToBottom(PortSide side) {
        return LNode.sortPortsTopToBottom(this.getTruePorts(side));
    }

    public List<LPort> getPortsSortedTopToBottom(PortSide side) {
        return LNode.sortPortsTopToBottom(this.getPortsAsList(side));
    }

    private static List<LPort> sortPortsTopToBottom(List<LPort> ports) {
        return ports.stream().sorted(Comparator.comparingDouble(p -> p.getPosition().y)).collect(Collectors.toList());
    }

    public boolean hasTrueWestPorts() {
        return this.getTruePorts().stream().anyMatch(p -> p.isOnSide(PortSide.WEST));
    }

    public boolean hasTrueEastWestPorts() {
        return this.getTruePorts().stream().anyMatch(p -> PortSide.isEastWest(p.getSide()));
    }

    public LPort getHighestTrueEastWestPort() {
        Stream<LPort> eastWestPorts = this.getTruePorts().stream().filter(p -> PortSide.isEastWest(p.getSide()));
        return eastWestPorts.min(Comparator.comparingDouble(p -> p.getPosition().y)).orElse(null);
    }

    public LPort getHighestPortWithEdge(PortSide side) {
        return this.getPortsWithEdgesSortedTopToBottom(side).findFirst().orElse(null);
    }

    public LPort getLowestPortWithEdge(PortSide side) {
        return this.getPortsWithEdgesSortedTopToBottom(side).reduce((first, second) -> second).orElse(null);
    }

    private Stream<LPort> getPortsWithEdgesSortedTopToBottom(PortSide side) {
        return this.getPortsSortedTopToBottom(side).stream().filter(p -> p.hasEdges());
    }

    public long getNumWestPorts() {
        return this.ports.stream().filter(p -> p.getSide() == PortSide.WEST).count();
    }

    public Double getTruePortSpacing(PortSide portSide) {
        List<LPort> portsOnSide = this.getTruePorts(portSide);
        if (this.ports.size() < 2) {
            return null;
        }
        return Math.abs(portsOnSide.get((int)1).getPosition().y - portsOnSide.get((int)0).getPosition().y);
    }

    public List<Pair<LPort, LPort>> getTrueEastAndWestAdjacentPortPairsSortedTopToBottom() {
        ArrayList<Pair<LPort, LPort>> portPairs = new ArrayList<Pair<LPort, LPort>>();
        portPairs.addAll(this.getTrueAdjacentPortPairsSortedTopToBottom(PortSide.EAST));
        portPairs.addAll(this.getTrueAdjacentPortPairsSortedTopToBottom(PortSide.WEST));
        return portPairs;
    }

    private List<Pair<LPort, LPort>> getTrueAdjacentPortPairsSortedTopToBottom(PortSide portSide) {
        ArrayList<Pair<LPort, LPort>> portPairs = new ArrayList<Pair<LPort, LPort>>();
        List<LPort> portsOnSide = this.getTruePortsSortedTopToBottom(portSide);
        int i = 0;
        while (i < portsOnSide.size() - 1) {
            portPairs.add(new Pair<LPort, LPort>(portsOnSide.get(i), portsOnSide.get(i + 1)));
            ++i;
        }
        return portPairs;
    }

    public List<LPort> getPortSideView(PortSide side) {
        Pair<Integer, Integer> indices;
        if (!this.portSidesCached) {
            this.findPortIndices();
        }
        if ((indices = this.portSideIndices.get((Object)side)) == null) {
            return Collections.emptyList();
        }
        return this.ports.subList(indices.getFirst(), indices.getSecond());
    }

    public Iterable<LPort> getPorts(PortType portType, PortSide side) {
        Predicate<LPort> typePredicate = null;
        switch (portType) {
            case INPUT: {
                typePredicate = LPort.INPUT_PREDICATE;
                break;
            }
            case OUTPUT: {
                typePredicate = LPort.OUTPUT_PREDICATE;
            }
        }
        Predicate<LPort> sidePredicate = null;
        switch (side) {
            case NORTH: {
                sidePredicate = LPort.NORTH_PREDICATE;
                break;
            }
            case EAST: {
                sidePredicate = LPort.EAST_PREDICATE;
                break;
            }
            case SOUTH: {
                sidePredicate = LPort.SOUTH_PREDICATE;
                break;
            }
            case WEST: {
                sidePredicate = LPort.WEST_PREDICATE;
            }
        }
        if (typePredicate != null && sidePredicate != null) {
            return Iterables.filter(this.ports, (Predicate)Predicates.and(typePredicate, sidePredicate));
        }
        return Collections.emptyList();
    }

    public boolean hasOutgoingEdges() {
        return !this.getOutgoingEdgesAsList().isEmpty();
    }

    public boolean allOutgoingEdgesArePartOfFeedbackLoops() {
        return this.getOutgoingEdgesAsList().stream().allMatch(outEdge -> outEdge.isPartOfFeedbackLoop());
    }

    public List<LEdge> getEdges() {
        return MesUtilMethods.iterableToList(Iterables.concat(this.getIncomingEdges(), this.getOutgoingEdges()));
    }

    public List<LEdge> getEdges(boolean forward) {
        return forward ? this.getOutgoingEdgesAsList() : this.getIncomingEdgesAsList();
    }

    public List<LEdge> getTrueEdges(boolean forward) {
        return forward ? this.getTrueOutgoingEdges() : this.getTrueIncomingEdges();
    }

    public List<LEdge> getTrueOutgoingEdges() {
        return this.getTrueEdges(p -> p.getOutgoingEdges());
    }

    public List<LEdge> getTrueIncomingEdges() {
        return this.getTrueEdges(p -> p.getIncomingEdges());
    }

    private List<LEdge> getTrueEdges(Function<LPort, List<LEdge>> getEdgesFunc) {
        return this.getTruePorts().stream().flatMap(p -> ((List)getEdgesFunc.apply((LPort)p)).stream()).collect(Collectors.toList());
    }

    public Iterable<LEdge> getIncomingEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getIncomingEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public List<LEdge> getIncomingEdgesAsList() {
        return MesUtilMethods.iterableToList(this.getIncomingEdges());
    }

    public Iterable<LEdge> getOutgoingEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public List<LEdge> getOutgoingEdgesAsList() {
        return MesUtilMethods.iterableToList(this.getOutgoingEdges());
    }

    public Iterable<LEdge> getConnectedEdges() {
        ArrayList iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getConnectedEdges());
        }
        return Iterables.concat((Iterable)iterables);
    }

    public List<LNode> getSourceNodes() {
        return this.getSourceOrTargetNodes(this.getIncomingEdges(), e -> e.getSource());
    }

    public List<LNode> getTargetNodes() {
        return this.getSourceOrTargetNodes(this.getOutgoingEdges(), e -> e.getTarget());
    }

    private List<LNode> getSourceOrTargetNodes(Iterable<LEdge> edges, Function<LEdge, LPort> edgeToPort) {
        return StreamSupport.stream(edges.spliterator(), false).map(edge -> ((LPort)edgeToPort.apply((LEdge)edge)).getNode()).distinct().collect(Collectors.toList());
    }

    public List<LNode> getConnectedNodes() {
        return Stream.concat(this.getSourceNodes().stream(), this.getTargetNodes().stream()).distinct().collect(Collectors.toList());
    }

    public List<LNode> getConnectedNodes(boolean forward) {
        return forward ? this.getTargetNodes() : this.getSourceNodes();
    }

    public List<LEdge> getEdgesConnectedWith(LNode connectedNode) {
        return this.getConnectedEdgesFilteredBy((Predicate<LEdge>)((Predicate)edge -> edge.getTargetNode() == connectedNode || edge.getSourceNode() == connectedNode));
    }

    public List<LEdge> getOutgoingEdgesTo(LNode targetNode) {
        return this.getConnectedEdgesFilteredBy((Predicate<LEdge>)((Predicate)edge -> edge.getTargetNode() == targetNode));
    }

    private List<LEdge> getConnectedEdgesFilteredBy(Predicate<LEdge> filterCondition) {
        ArrayList<LEdge> filteredEdges = new ArrayList<LEdge>();
        for (LEdge edge : this.getConnectedEdges()) {
            if (!filterCondition.apply((Object)edge)) continue;
            filteredEdges.add(edge);
        }
        return filteredEdges;
    }

    public List<LNode> getTrueTargetNodesSkippingLongEdgeDummies() {
        return this.getTrueSourceOrTargetNodesSkippingLongEdgeDummies(n -> n.getTrueTargetNodes());
    }

    public List<LNode> getTrueSourceNodesSkippingLongEdgeDummies() {
        return this.getTrueSourceOrTargetNodesSkippingLongEdgeDummies(n -> n.getTrueSourceNodes());
    }

    private List<LNode> getTrueSourceOrTargetNodesSkippingLongEdgeDummies(Function<LNode, List<LNode>> funcToGetSourceOrTargetNodes) {
        ArrayList sourceOrTargetNodes = Lists.newArrayList();
        for (LNode currentSourceOrTargetNode : funcToGetSourceOrTargetNodes.apply(this)) {
            if (currentSourceOrTargetNode.isLongEdge()) {
                sourceOrTargetNodes.addAll(currentSourceOrTargetNode.getTrueSourceOrTargetNodesSkippingLongEdgeDummies(funcToGetSourceOrTargetNodes));
                continue;
            }
            sourceOrTargetNodes.add(currentSourceOrTargetNode);
        }
        return sourceOrTargetNodes.stream().distinct().collect(Collectors.toList());
    }

    public LNode getTrueNode() {
        if (this.isWideNode()) {
            return this.getOriginalWideNode();
        }
        return this;
    }

    public boolean hasTrueSourceNodes() {
        return !this.getTrueSourceNodes().isEmpty();
    }

    public List<LNode> getTrueSourceNodes() {
        return this.getTrueSourceOrTargetNodes(n -> n.getSourceNodes());
    }

    public boolean hasTrueTargetNodes() {
        return !this.getTrueTargetNodes().isEmpty();
    }

    public List<LNode> getTrueTargetNodes() {
        return this.getTrueSourceOrTargetNodes(n -> n.getTargetNodes());
    }

    private List<LNode> getTrueSourceOrTargetNodes(Function<LNode, List<LNode>> funcToGetSourceOrTargetNodes) {
        if (this.wasSplitIntoWideNodes()) {
            List<LNode> dummies = this.getWideNodeDummies();
            ArrayList<LNode> sourceOrTargetNodes = new ArrayList<LNode>();
            dummies.forEach(d -> {
                boolean bl = sourceOrTargetNodes.addAll((Collection)funcToGetSourceOrTargetNodes.apply((LNode)d));
            });
            sourceOrTargetNodes.removeAll(dummies);
            return sourceOrTargetNodes;
        }
        return funcToGetSourceOrTargetNodes.apply(this);
    }

    public List<LNode> getTrueConnectedNodes() {
        return Stream.concat(this.getTrueSourceNodes().stream(), this.getTrueTargetNodes().stream()).distinct().collect(Collectors.toList());
    }

    public List<LPort> getTrueTargetPorts() {
        return this.getTrueOutgoingEdges().stream().map(e -> e.getTarget()).collect(Collectors.toList());
    }

    public List<LPort> getTruePorts() {
        if (this.wasSplitIntoWideNodes()) {
            return this.getWideNodeDummies().stream().flatMap(d -> d.getPorts().stream().filter(p -> p.getProperty(InternalProperties.WIDE_NODE_INNER_PORT) == false)).collect(Collectors.toList());
        }
        return this.getPorts();
    }

    public List<LPort> getTrueConnectedPorts() {
        return this.getTruePorts().stream().map(p -> p.getConnectedPortsAsList()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public long getNumTrueWestPorts() {
        return this.getTruePortsAsStream(PortSide.WEST).count();
    }

    public long getNumTrueEastPorts() {
        return this.getTruePortsAsStream(PortSide.EAST).count();
    }

    public long getNumTruePorts(PortSide side) {
        return this.getTruePortsAsStream(side).count();
    }

    public List<LPort> getTruePorts(PortSide side) {
        return this.getTruePortsAsStream(side).collect(Collectors.toList());
    }

    public List<LPort> getTruePortsSortedTopToBottom() {
        return LNode.sortPortsTopToBottom(this.getTruePorts());
    }

    private Stream<LPort> getTruePortsAsStream(PortSide side) {
        return this.getTruePorts().stream().filter(p -> p.getSide().equals((Object)side));
    }

    public boolean hasTruePorts(PortSide side) {
        return this.getTruePorts().stream().anyMatch(p -> p.getSide().equals((Object)side));
    }

    public boolean hasNorthSouthPort() {
        return this.getTruePorts().stream().anyMatch(port -> port.isNorthOrSouthPort());
    }

    public LNode getUpperNeighbor() {
        return this.hasUpperNeighbor() ? this.getLayer().getNodes().get(this.getIndex() - 1) : null;
    }

    public boolean hasUpperNeighbor() {
        return this.getIndex() > 0;
    }

    public LNode getLowerNeighbor() {
        return this.hasLowerNeighbor() ? this.getLayer().getNodes().get(this.getIndex() + 1) : null;
    }

    public boolean hasLowerNeighbor() {
        return this.getIndex() < this.getLayer().getNodes().size() - 1;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LGraph getNestedGraph() {
        return this.nestedGraph;
    }

    public void setNestedGraph(LGraph nestedGraph) {
        this.nestedGraph = nestedGraph;
    }

    public LMargin getMargin() {
        return this.margin;
    }

    public LPadding getPadding() {
        return this.padding;
    }

    public void setOriginalWideNode(LNode node) {
        this.originalWideNode = node;
    }

    public LNode getOriginalWideNode() {
        return this.originalWideNode;
    }

    public LMargin getLabelMargin() {
        return this.labelMargin;
    }

    public int getIndex() {
        if (this.layer == null) {
            return -1;
        }
        return this.layer.getNodes().indexOf(this);
    }

    public void borderToContentAreaCoordinates(boolean horizontal, boolean vertical) {
        LGraph thegraph = this.getGraph();
        LPadding graphPadding = thegraph.getPadding();
        KVector offset = thegraph.getOffset();
        KVector pos = this.getPosition();
        if (horizontal) {
            pos.x = pos.x - graphPadding.left - offset.x;
        }
        if (vertical) {
            pos.y = pos.y - graphPadding.top - offset.y;
        }
    }

    public boolean isFirstSeparate() {
        return this.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE;
    }

    public boolean isLastSeparate() {
        return this.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE;
    }

    public boolean isSeparate() {
        return this.isFirstSeparate() || this.isLastSeparate();
    }

    public int getPortBlockNumber() {
        String portNum = this.getMesBlockParam("Port");
        return portNum == null ? -1 : Integer.parseInt(portNum);
    }

    public String getMesBlockParam(String paramName) {
        return this.getMesBlockParametersMap().getParam(paramName);
    }

    private MesBlockParametersMap getMesBlockParametersMap() {
        return this.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP);
    }

    public void setMesBlockParam(String paramName, String paramValue) {
        this.getMesBlockParametersMap().setParam(paramName, paramValue);
    }

    public boolean isPortBlockNode() {
        return this.isOfMesBlockType("Inport") || this.isOfMesBlockType("Outport");
    }

    public boolean isGotoNode() {
        return this.isOfMesBlockType("Goto");
    }

    public boolean isFromNode() {
        return this.isOfMesBlockType("From");
    }

    public boolean isWideNode() {
        return this.getType().equals((Object)NodeType.WIDE_NODE);
    }

    public boolean isNorthSouthDummy() {
        return this.getType() == NodeType.NORTH_SOUTH_PORT;
    }

    public boolean isNorthSouthDummyForNorthPort() {
        return this.isNorthSouthDummy() && this.originIsNorthPort();
    }

    private boolean originIsNorthPort() {
        return ((LPort)this.getPorts().get(0).getProperty(InternalProperties.ORIGIN)).isOnSide(PortSide.NORTH);
    }

    public boolean isCommentBox() {
        return this.getProperty(LayeredOptions.COMMENT_BOX);
    }

    public boolean isLastGotoWideNodeDummyWithFirstFromWideNodeDummy(LNode otherNode) {
        return this.isNonWideNodeDummyOrLast() && otherNode.isNonWideNodeDummyOrFirst() && this.isGotoNode() && otherNode.isFromNodeWithTag(this.getMesBlockParam("GotoTag"));
    }

    private boolean isNonWideNodeDummyOrLast() {
        return !this.isWideNode() || this.getWideNodeDummies().indexOf(this) == this.getWideNodeDummies().size() - 1;
    }

    private boolean isNonWideNodeDummyOrFirst() {
        return !this.isWideNode() || this.getWideNodeDummies().indexOf(this) == 0;
    }

    private boolean isFromNodeWithTag(String tag) {
        return this.isFromNode() && this.getMesBlockParam("GotoTag").equals(tag);
    }

    public boolean isOfMesBlockType(String blockType) {
        return this.mesBlockParamEquals("BlockType", blockType);
    }

    private boolean mesBlockParamEquals(String paramName, String paramValue) {
        String paramValueOrNull = this.getMesBlockParam(paramName);
        return paramValueOrNull != null && paramValueOrNull.equals(paramValue);
    }

    public boolean isDelayNode() {
        ArrayList blockTypesToCheck = Lists.newArrayList((Object[])new String[]{"Delay", "UnitDelay", "Memory"});
        return blockTypesToCheck.stream().anyMatch(blockType -> this.isOfMesBlockType((String)blockType));
    }

    public void setWideNodeDummies(List<LNode> dummies) {
        this.wideNodeDummies = dummies;
    }

    public List<LNode> getWideNodeDummies() {
        if (this.originalWideNode == null) {
            return this.wideNodeDummies;
        }
        return this.originalWideNode.wideNodeDummies;
    }

    public boolean isFirstWideNodeDummy() {
        return this.isWideNode() && this == this.getFirstWideNodeDummy();
    }

    public boolean isFirstWideNodeDummyOrNonWideNode(LNode node) {
        return !node.isWideNode() || node.isFirstWideNodeDummy();
    }

    public LNode getFirstWideNodeDummy() {
        if (this.wasSplitIntoWideNodes()) {
            return this.getWideNodeDummies().get(0);
        }
        return this;
    }

    public boolean isNonLastWideNodeDummy() {
        return this.isWideNode() && !this.isLastWideNodeDummy();
    }

    public boolean isLastWideNodeDummy() {
        return this.isWideNode() && this == this.getLastWideNodeDummy();
    }

    public LNode getLastWideNodeDummy() {
        if (this.wasSplitIntoWideNodes()) {
            List<LNode> dummies = this.getWideNodeDummies();
            return dummies.get(dummies.size() - 1);
        }
        return this;
    }

    public boolean isLastNonLabelWideNodeDummy() {
        return this.isWideNode() && this == this.getLastNonLabelWideNodeDummy();
    }

    public LNode getLastNonLabelWideNodeDummy() {
        if (this.wasSplitIntoWideNodes()) {
            List<LNode> dummies = this.getWideNodeDummies();
            return dummies.get(dummies.size() - 1 - this.getNumRightLabelWideNodeDummies());
        }
        return this;
    }

    public boolean isFirstNonLabelWideNodeDummy() {
        return this.isWideNode() && this == this.getFirstNonLabelOfWideNodes();
    }

    public LNode getFirstNonLabelOfWideNodes() {
        if (this.wasSplitIntoWideNodes()) {
            return this.getWideNodeDummies().get(this.getNumLeftLabelWideNodeDummies());
        }
        return this;
    }

    public LNode getMiddleOfNonLabelOfWideNodes() {
        if (this.wasSplitIntoWideNodes()) {
            List<LNode> dummies = this.getWideNodeDummies();
            int numLabelDummiesLeft = this.getNumLeftLabelWideNodeDummies();
            int numLabelDummiesRight = this.getNumRightLabelWideNodeDummies();
            int ixMiddle = numLabelDummiesLeft + (dummies.size() - 1 - numLabelDummiesLeft - numLabelDummiesRight) / 2;
            return dummies.get(ixMiddle);
        }
        return this;
    }

    private int getNumRightLabelWideNodeDummies() {
        List<LNode> dummies = this.getWideNodeDummies();
        int numRightLabelWideNodeDummies = 0;
        int ixDummy = dummies.size() - 1;
        while (ixDummy >= 0 && dummies.get(ixDummy).getWideNodeDummyType().equals((Object)WideNodeDummyType.LABEL)) {
            --ixDummy;
            ++numRightLabelWideNodeDummies;
        }
        return numRightLabelWideNodeDummies;
    }

    private int getNumLeftLabelWideNodeDummies() {
        List<LNode> dummies = this.getWideNodeDummies();
        int numLeftLabelWideNodeDummies = 0;
        int ixDummy = 0;
        while (ixDummy < dummies.size() && dummies.get(ixDummy).getWideNodeDummyType().equals((Object)WideNodeDummyType.LABEL)) {
            ++ixDummy;
            ++numLeftLabelWideNodeDummies;
        }
        return numLeftLabelWideNodeDummies;
    }

    public int getNumWideNodeDummies() {
        return this.isWideNode() ? this.getWideNodeDummies().size() : 1;
    }

    public long getNumNonLabelWideNodeDummies() {
        if (this.wasSplitIntoWideNodes()) {
            List<LNode> dummies = this.getWideNodeDummies();
            return dummies.stream().filter(d -> !d.getWideNodeDummyType().equals((Object)WideNodeDummyType.LABEL)).count();
        }
        return 1L;
    }

    public long getNumLabelWideNodeDummies() {
        return (long)this.getNumWideNodeDummies() - this.getNumNonLabelWideNodeDummies();
    }

    private boolean wasSplitIntoWideNodes() {
        return this.isWideNode() || this.isWideNodeOrigin();
    }

    private boolean isWideNodeOrigin() {
        return this.getWideNodeDummies() != null;
    }

    public LNode getNextWideNodeDummy() {
        int ixDummy = this.getWideNodeDummies().indexOf(this);
        if (ixDummy == this.getWideNodeDummies().size() - 1) {
            return null;
        }
        return this.getWideNodeDummies().get(ixDummy + 1);
    }

    public double getLeftLabelWidth() {
        if (this.isWideNode()) {
            if (this.getFirstNonLabelOfWideNodes() == this) {
                return this.originalWideNode.labelMargin.left - this.getWidthOfWideNodeLeftFromThisDummy();
            }
            return 0.0;
        }
        return this.labelMargin.left;
    }

    public double getRightLabelWidth() {
        if (this.isWideNode()) {
            if (this.getLastNonLabelWideNodeDummy() == this) {
                return this.originalWideNode.labelMargin.right - this.getWidthOfWideNodeRightFromThisDummy();
            }
            return 0.0;
        }
        return this.labelMargin.right;
    }

    private WideNodeDummyType getWideNodeDummyType() {
        double spacing = this.getGraph().getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double leftXOfCurrentDummy = this.getWidthOfWideNodeLeftFromThisDummy();
        double rightXOfCurrentDummy = leftXOfCurrentDummy + this.getSize().x + spacing;
        double leftXLabelStart = this.originalWideNode.labelMargin.left;
        double rightXLabelStart = this.originalWideNode.getSize().x - this.originalWideNode.labelMargin.right;
        if (rightXOfCurrentDummy <= leftXLabelStart || leftXOfCurrentDummy >= rightXLabelStart) {
            return WideNodeDummyType.LABEL;
        }
        if (leftXOfCurrentDummy < leftXLabelStart && rightXOfCurrentDummy > leftXLabelStart || leftXOfCurrentDummy < rightXLabelStart && rightXOfCurrentDummy > rightXLabelStart) {
            return WideNodeDummyType.MIXED;
        }
        return WideNodeDummyType.NODE;
    }

    private double getWidthOfWideNodeLeftFromThisDummy() {
        if (this.getType() == NodeType.WIDE_NODE) {
            double spacing = this.getGraph().getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
            int indexOfNode = this.getWideNodeDummies().indexOf(this);
            if (indexOfNode == 0) {
                return 0.0;
            }
            return this.getWideNodeDummies().subList(0, indexOfNode).stream().mapToDouble(n -> n.getSize().x + spacing).sum();
        }
        return 0.0;
    }

    private double getWidthOfWideNodeRightFromThisDummy() {
        if (this.getType() == NodeType.WIDE_NODE) {
            double spacing = this.getGraph().getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
            int indexOfNode = this.getWideNodeDummies().indexOf(this);
            if (indexOfNode == this.getWideNodeDummies().size() - 1) {
                return 0.0;
            }
            return this.getWideNodeDummies().subList(indexOfNode + 1, this.getWideNodeDummies().size()).stream().mapToDouble(n -> n.getSize().x + spacing).sum();
        }
        return 0.0;
    }

    public ElkNode getOrigin() {
        return (ElkNode)this.getProperty(InternalProperties.ORIGIN);
    }

    public List<LNode> getWideNodeDummiesOrNodeItself() {
        return this.isWideNode() ? this.getWideNodeDummies() : Arrays.asList(this);
    }

    public LNode getWideNodeDummyOrNodeItselfInLayer(Layer layerToSearch) {
        return this.getWideNodeDummiesOrNodeItself().stream().filter(d -> layerToSearch.getNodes().contains(d)).findFirst().orElse(null);
    }

    public KVector getInteractiveReferencePoint() {
        switch (this.getGraph().getProperty(LayeredOptions.INTERACTIVE_REFERENCE_POINT)) {
            case CENTER: {
                KVector nodePos = this.getPosition();
                KVector nodeSize = this.getSize();
                return new KVector(nodePos.x + nodeSize.x / 2.0, nodePos.y + nodeSize.y / 2.0);
            }
            case TOP_LEFT: {
                return new KVector(this.getPosition());
            }
        }
        return null;
    }

    public void cachePortSides() {
        this.portSidesCached = true;
        this.findPortIndices();
    }

    private void findPortIndices() {
        this.portSideIndices = Maps.newEnumMap(PortSide.class);
        int firstIndexForCurrentSide = 0;
        PortSide currentSide = PortSide.NORTH;
        int currentIndex = 0;
        while (currentIndex < this.ports.size()) {
            LPort port = this.ports.get(currentIndex);
            if (port.getSide() != currentSide) {
                if (firstIndexForCurrentSide != currentIndex) {
                    this.portSideIndices.put(currentSide, Pair.of(firstIndexForCurrentSide, currentIndex));
                }
                currentSide = port.getSide();
                firstIndexForCurrentSide = currentIndex;
            }
            ++currentIndex;
        }
        this.portSideIndices.put(currentSide, Pair.of(firstIndexForCurrentSide, currentIndex));
    }

    public boolean isInSameFeedbackLoopAs(LNode node) {
        List<Integer> feedbackLoopsIdsOfThisNode = this.getProperty(InternalProperties.FEEDBACK_LOOP_IDS);
        List<Integer> feedbackLoopsIdsOfOtherNode = node.getProperty(InternalProperties.FEEDBACK_LOOP_IDS);
        return feedbackLoopsIdsOfThisNode.stream().anyMatch(feedbackLoopsIdsOfOtherNode::contains);
    }

    public boolean isSingleFlippedNodeInFeedbackLoop() {
        return this.isSingleFlippedNodeInFeedbackLoop;
    }

    public void setIsSingleFlippedNodeInFeedbackLoop(boolean tf) {
        this.isSingleFlippedNodeInFeedbackLoop = tf;
    }

    @Override
    public String getDesignation() {
        if (!this.labels.isEmpty() && !Strings.isNullOrEmpty((String)this.labels.get(0).getText())) {
            return this.labels.get(0).getText();
        }
        String id = super.getDesignation();
        if (id != null) {
            return id;
        }
        return Integer.toString(this.getIndex());
    }

    public String toString() {
        String result = this.toStringOriginal();
        Object originObj = this.getProperty(InternalProperties.ORIGIN);
        if (originObj != null && originObj instanceof ElkNodeImpl) {
            ElkNodeImpl origin = (ElkNodeImpl)originObj;
            result = origin.getIdentifier();
            if (result != null && result.contains("/")) {
                result = result.substring(result.lastIndexOf("/") + 1);
            }
            if (this.originalWideNode != null) {
                int indexInWideNode = this.getWideNodeDummies().indexOf(this);
                result = String.valueOf(result) + "_W" + indexInWideNode;
            }
        }
        return result;
    }

    public String toStringOriginal() {
        StringBuilder result = new StringBuilder();
        result.append("n");
        if (this.type != NodeType.NORMAL) {
            result.append("(").append(this.type.toString().toLowerCase()).append(")");
        }
        result.append("_").append(this.getDesignation());
        return result.toString();
    }

    public static enum NodeType {
        NORMAL,
        LONG_EDGE,
        EXTERNAL_PORT,
        NORTH_SOUTH_PORT,
        LABEL,
        WIDE_NODE,
        BREAKING_POINT;


        public String getColor() {
            switch (this) {
                case EXTERNAL_PORT: {
                    return "#cc99cc";
                }
                case LONG_EDGE: {
                    return "#eaed00";
                }
                case NORTH_SOUTH_PORT: {
                    return "#0034de";
                }
                case LABEL: {
                    return "#75c3c3";
                }
                case WIDE_NODE: {
                    return "#cccccc";
                }
                case BREAKING_POINT: {
                    return "#eeeeff";
                }
            }
            return "#eeeeee";
        }
    }

    private static enum WideNodeDummyType {
        NODE,
        LABEL,
        MIXED;

    }
}

