/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import java.util.List;
import java.util.function.Function;

public final class LEdge
extends LGraphElement {
    private static final long serialVersionUID = 1429497419118554817L;
    private KVectorChain bendPoints = new KVectorChain();
    private LPort source;
    private LPort target;
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)3);

    public void reverse(LGraph layeredGraph, boolean adaptPorts) {
        LPort oldSource = this.getSource();
        LPort oldTarget = this.getTarget();
        this.setSource(null);
        this.setTarget(null);
        if (adaptPorts && oldTarget.getProperty(InternalProperties.INPUT_COLLECT).booleanValue()) {
            this.setSource(LGraphUtil.provideCollectorPort(layeredGraph, oldTarget.getNode(), PortType.OUTPUT, PortSide.EAST));
        } else {
            this.setSource(oldTarget);
        }
        if (adaptPorts && oldSource.getProperty(InternalProperties.OUTPUT_COLLECT).booleanValue()) {
            this.setTarget(LGraphUtil.provideCollectorPort(layeredGraph, oldSource.getNode(), PortType.INPUT, PortSide.WEST));
        } else {
            this.setTarget(oldSource);
        }
        for (LLabel label : this.labels) {
            EdgeLabelPlacement labelPlacement = label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT);
            if (labelPlacement == EdgeLabelPlacement.TAIL) {
                label.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                continue;
            }
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            label.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
        }
        boolean reversed = this.getProperty(InternalProperties.REVERSED);
        this.setProperty(InternalProperties.REVERSED, (Object)(!reversed ? 1 : 0));
        this.bendPoints = KVectorChain.reverse(this.bendPoints);
    }

    public LPort getSource() {
        return this.source;
    }

    public void setSource(LPort source) {
        if (this.source != null) {
            this.source.getOutgoingEdges().remove(this);
        }
        this.source = source;
        if (this.source != null) {
            this.source.getOutgoingEdges().add(this);
        }
    }

    public LPort getTarget() {
        return this.target;
    }

    public void setTarget(LPort target) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove(this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.getIncomingEdges().add(this);
        }
    }

    public LPort getPort(boolean forward) {
        return forward ? this.getTarget() : this.getSource();
    }

    public void setTargetAndInsertAtIndex(LPort targetPort, int index) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove(this);
        }
        this.target = targetPort;
        if (this.target != null) {
            this.target.getIncomingEdges().add(index, this);
        }
    }

    public LNode getNode(boolean forward) {
        return forward ? this.getTargetNode() : this.getSourceNode();
    }

    public LNode getSourceNode() {
        return this.getNodeOfPortOrNull(this.getSource());
    }

    public LNode getTargetNode() {
        return this.getNodeOfPortOrNull(this.getTarget());
    }

    private LNode getNodeOfPortOrNull(LPort port) {
        if (port == null) {
            return null;
        }
        return port.getNode();
    }

    public LNode getNodeSkippingLongEdges(boolean forward) {
        return this.getPortSkippingLongEdges(forward).getNode();
    }

    public PortSide getSourceSide() {
        return this.getSideOfPortOrNull(this.getSource());
    }

    public PortSide getTargetSide() {
        return this.getSideOfPortOrNull(this.getTarget());
    }

    public boolean isConnectedTo(LNode node) {
        return this.getTargetNode() == node || this.getSourceNode() == node;
    }

    private PortSide getSideOfPortOrNull(LPort port) {
        if (port == null) {
            return null;
        }
        return port.getSide();
    }

    public boolean isSelfLoop() {
        if (this.source == null || this.target == null) {
            return false;
        }
        return this.source.getNode() != null && this.source.getNode() == this.target.getNode();
    }

    public boolean isPartOfFeedbackLoop() {
        return !this.getProperty(InternalProperties.FEEDBACK_LOOP_IDS).isEmpty();
    }

    public boolean isInLayerEdge() {
        return !this.isSelfLoop() && this.source.getNode().getLayer() == this.target.getNode().getLayer();
    }

    public boolean isHorizontal() {
        return this.getSourceNode().getLayer() != this.getTargetNode().getLayer();
    }

    public boolean isInnerWideNodeEdge() {
        return this.getSource().isWideNodeInnerPort();
    }

    public boolean isDoubleEdgeToLongEdgeDummy() {
        LNode targetNode = this.getTargetNode();
        List<LEdge> incomingEdgesOfTarget = targetNode.getIncomingEdgesAsList();
        return targetNode.isLongEdge() && incomingEdgesOfTarget.stream().anyMatch(e -> e.getSource() == this.getSource() && incomingEdgesOfTarget.indexOf(e) < incomingEdgesOfTarget.indexOf(this));
    }

    public boolean isSplitEdgeToHighestPort() {
        return this.isSplitEdgeTo(cps -> cps.stream().noneMatch(cp -> cp.isAbove(this.getTarget())));
    }

    public boolean isSplitEdgeToNonHighestPort() {
        return this.isSplitEdgeTo(cps -> cps.stream().anyMatch(cp -> cp.isAbove(this.getTarget())));
    }

    public boolean isSplitEdgeToLowestPort() {
        return this.isSplitEdgeTo(cps -> cps.stream().noneMatch(cp -> this.getTarget().isAbove((LPort)cp)));
    }

    public boolean isSplitEdgeToNonLowestPort() {
        return this.isSplitEdgeTo(cps -> cps.stream().anyMatch(cp -> this.getTarget().isAbove((LPort)cp)));
    }

    public boolean isSplitEdgeToMiddlePort() {
        return this.isSplitEdgeTo(cps -> cps.stream().anyMatch(cp -> cp.isAbove(this.getTarget())) && cps.stream().anyMatch(cp -> this.getTarget().isAbove((LPort)cp)));
    }

    private boolean isSplitEdgeTo(Function<List<LPort>, Boolean> func) {
        if (this.isHorizontal()) {
            List<LPort> connectedPortsOfSourceInOtherLayer = this.getSource().getDistinctConnectedPortsInOtherLayer();
            return connectedPortsOfSourceInOtherLayer.size() > 1 && func.apply(connectedPortsOfSourceInOtherLayer) != false;
        }
        return false;
    }

    public LPort getTargetSkippingLongEdges() {
        return this.getPortSkippingLongEdges(true);
    }

    public LPort getSourceSkippingLongEdges() {
        return this.getPortSkippingLongEdges(false);
    }

    public LPort getPortSkippingLongEdges(boolean forward) {
        IProperty<LPort> longEdgeProperty = forward ? InternalProperties.LONG_EDGE_TARGET : InternalProperties.LONG_EDGE_SOURCE;
        return this.getNode(forward).isLongEdge() ? this.getPortSkippingLongEdges(forward, longEdgeProperty) : this.getPort(forward);
    }

    private LPort getPortSkippingLongEdges(boolean forward, IProperty<LPort> longEdgeProperty) {
        LPort portSkippingLongEdges = this.getNode(forward).getProperty(longEdgeProperty);
        return portSkippingLongEdges != null && portSkippingLongEdges.isNorthOrSouthPort() ? portSkippingLongEdges.getDummyPort(forward) : portSkippingLongEdges;
    }

    public boolean isFromTo(PortSide sourceSide, PortSide targetSide) {
        return this.getSource().getSide().equals((Object)sourceSide) && this.getTarget().getSide().equals((Object)targetSide);
    }

    public KVectorChain getBendPoints() {
        return this.bendPoints;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LPort getOther(LPort port) {
        if (port == this.source) {
            return this.target;
        }
        if (port == this.target) {
            return this.source;
        }
        throw new IllegalArgumentException("'port' must be either the source port or target port of the edge.");
    }

    public LNode getOther(LNode node) {
        if (node == this.source.getNode()) {
            return this.target.getNode();
        }
        if (node == this.target.getNode()) {
            return this.source.getNode();
        }
        throw new IllegalArgumentException("'node' must either be the source node or target node of the edge.");
    }

    @Override
    public String getDesignation() {
        if (!this.labels.isEmpty() && !Strings.isNullOrEmpty((String)this.labels.get(0).getText())) {
            return this.labels.get(0).getText();
        }
        return super.getDesignation();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("e_");
        String designation = this.getDesignation();
        if (designation != null) {
            result.append(designation);
        }
        if (this.source != null && this.target != null) {
            result.append(" ").append(this.source.getDesignation());
            result.append("[").append(this.source.getNode()).append("]");
            result.append(" -> ").append(this.target.getDesignation());
            result.append("[").append(this.target.getNode()).append("]");
        }
        return result.toString();
    }
}

