/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered;

import com.modelengineers.MoRe_elk.alg.layered.ElkLayered;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.transform.ElkGraphTransformer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.testing.IWhiteBoxTestable;
import com.modelengineers.MoRe_elk.core.testing.TestController;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkNode;

public final class LayeredLayoutProvider
extends AbstractLayoutProvider
implements IWhiteBoxTestable {
    private final ElkLayered elkLayered = new ElkLayered();

    @Override
    public void layout(ElkNode elkgraph, IElkProgressMonitor progressMonitor) {
        try {
            boolean loggingEnabled = elkgraph.getProperty(LayeredOptions.ENABLE_LOGGING_MES_MORE);
            long runTime = MesUtilMethods.measureRuntime(() -> this.layoutGraph(elkgraph, progressMonitor), "Layout", loggingEnabled);
            elkgraph.setProperty(InternalProperties.ELAPSED_TIME, (int)runTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void layoutGraph(ElkNode elkgraph, IElkProgressMonitor progressMonitor) throws InterruptedException {
        ElkGraphTransformer graphTransformer = new ElkGraphTransformer();
        LGraph layeredGraph = graphTransformer.importGraph(elkgraph);
        this.elkLayered.doLayout(layeredGraph, progressMonitor);
        if (!progressMonitor.isCanceled()) {
            graphTransformer.applyLayout(layeredGraph);
        }
    }

    public ElkLayered.TestExecutionState startLayoutTest(ElkNode elkgraph) {
        ElkGraphTransformer graphImporter = new ElkGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(elkgraph);
        return this.elkLayered.prepareLayoutTest(layeredGraph);
    }

    public ElkLayered getLayoutAlgorithm() {
        return this.elkLayered;
    }

    @Override
    public void setTestController(TestController controller) {
        this.elkLayered.setTestController(controller);
    }
}

