/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered;

import com.modelengineers.MoRe_elk.alg.layered.DebugUtil;
import com.modelengineers.MoRe_elk.alg.layered.GraphConfigurator;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.ContentAlignment;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.options.SizeOptions;
import com.modelengineers.MoRe_elk.core.testing.TestController;
import com.modelengineers.MoRe_elk.core.util.BasicProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class ElkLayered {
    private final GraphConfigurator graphConfigurator = new GraphConfigurator();
    private TestController testController = null;

    public void doLayout(LGraph lgraph, IElkProgressMonitor monitor) throws InterruptedException {
        IElkProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor().withMaxHierarchyLevels(0);
        }
        theMonitor.begin("Layered layout", 1.0f);
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        this.layout(lgraph, theMonitor);
        this.resizeGraph(lgraph);
        theMonitor.done();
    }

    private boolean isRoot(LGraph graph) {
        return graph.getParentNode() == null;
    }

    public TestExecutionState prepareLayoutTest(LGraph lgraph) {
        TestExecutionState state = new TestExecutionState();
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        state.graphs = Arrays.asList(lgraph);
        return state;
    }

    public boolean isLayoutTestFinished(TestExecutionState state) {
        LGraph graph = (LGraph)state.graphs.get(0);
        List<ILayoutProcessor<LGraph>> algorithm = graph.getProperty(InternalProperties.PROCESSORS);
        return algorithm != null && state.step >= algorithm.size();
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor<LGraph>> phase, boolean inclusive, TestExecutionState state) throws InterruptedException {
        List<ILayoutProcessor<LGraph>> algorithm = ((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        boolean phaseExists = false;
        ListIterator<ILayoutProcessor<LGraph>> algorithmIterator = algorithm.listIterator(state.step);
        int phaseIndex = state.step;
        while (algorithmIterator.hasNext() && !phaseExists) {
            if (algorithmIterator.next().getClass().equals(phase)) {
                phaseExists = true;
                if (!inclusive) continue;
                ++phaseIndex;
                continue;
            }
            ++phaseIndex;
        }
        if (!phaseExists) {
            System.err.println("Given processor " + phase + " not part of the remaining algorithm.");
        }
        algorithmIterator = algorithm.listIterator(state.step);
        while (state.step < phaseIndex) {
            this.layoutTest(state.graphs, algorithmIterator.next());
            TestExecutionState testExecutionState = state;
            testExecutionState.step = testExecutionState.step + 1;
        }
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor<LGraph>> phase, TestExecutionState state) throws InterruptedException {
        this.runLayoutTestUntil(phase, true, state);
    }

    public void runLayoutTestStep(TestExecutionState state) throws InterruptedException {
        if (this.isLayoutTestFinished(state)) {
            throw new IllegalStateException("Current layout test run has finished.");
        }
        List<ILayoutProcessor<LGraph>> algorithm = ((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        this.layoutTest(state.graphs, algorithm.get(state.step));
        TestExecutionState testExecutionState = state;
        testExecutionState.step = testExecutionState.step + 1;
    }

    public List<ILayoutProcessor<LGraph>> getLayoutTestConfiguration(TestExecutionState state) {
        return ((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
    }

    public void setTestController(TestController testController) {
        this.testController = testController;
    }

    private void notifyProcessorReady(LGraph lgraph, ILayoutProcessor<?> processor) {
        if (this.testController != null) {
            if (this.isRoot(lgraph)) {
                this.testController.notifyRootProcessorReady(lgraph, processor);
            } else {
                this.testController.notifyProcessorReady(lgraph, processor);
            }
        }
    }

    private void notifyProcessorFinished(LGraph lgraph, ILayoutProcessor<?> processor) {
        if (this.testController != null) {
            if (this.isRoot(lgraph)) {
                this.testController.notifyRootProcessorFinished(lgraph, processor);
            } else {
                this.testController.notifyProcessorFinished(lgraph, processor);
            }
        }
    }

    private void layout(LGraph lgraph, IElkProgressMonitor monitor) throws InterruptedException {
        boolean monitorWasAlreadyRunning = monitor.isRunning();
        if (!monitorWasAlreadyRunning) {
            monitor.begin("Component Layout", 1.0f);
        }
        List<ILayoutProcessor<LGraph>> algorithm = lgraph.getProperty(InternalProperties.PROCESSORS);
        float monitorProgress = 1.0f / (float)algorithm.size();
        if (monitor.isLoggingEnabled()) {
            monitor.log("ELK Layered uses the following " + algorithm.size() + " modules:");
            int slot = 0;
            for (ILayoutProcessor iLayoutProcessor : algorithm) {
                String gwtDoesntSupportPrintf = String.valueOf(slot < 10 ? "0" : "") + slot++;
                monitor.log("   Slot " + gwtDoesntSupportPrintf + ": " + iLayoutProcessor.getClass().getName());
            }
        }
        int slotIndex = 0;
        for (ILayoutProcessor<LGraph> iLayoutProcessor : algorithm) {
            MesUtilMethods.checkInterrupt();
            if (monitor.isCanceled()) {
                return;
            }
            if (monitor.isLoggingEnabled()) {
                DebugUtil.logDebugGraph(monitor, lgraph, slotIndex, "Before " + iLayoutProcessor.getClass().getSimpleName());
            }
            this.notifyProcessorReady(lgraph, iLayoutProcessor);
            iLayoutProcessor.process(lgraph, monitor.subTask(monitorProgress));
            this.notifyProcessorFinished(lgraph, iLayoutProcessor);
            ++slotIndex;
        }
        if (monitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(monitor, lgraph, slotIndex, "Finished");
        }
        for (Layer layer : lgraph) {
            lgraph.getLayerlessNodes().addAll(layer.getNodes());
            layer.getNodes().clear();
        }
        for (LNode lNode : lgraph.getLayerlessNodes()) {
            lNode.setLayer(null);
        }
        lgraph.getLayers().clear();
        if (!monitorWasAlreadyRunning) {
            monitor.done();
        }
    }

    private void layoutTest(List<LGraph> lgraphs, ILayoutProcessor<LGraph> processor) throws InterruptedException {
        for (LGraph lgraph : lgraphs) {
            this.notifyProcessorReady(lgraph, processor);
            processor.process(lgraph, new BasicProgressMonitor());
            this.notifyProcessorFinished(lgraph, processor);
        }
    }

    private void resizeGraph(LGraph lgraph) {
        Set sizeConstraint = lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        Set sizeOptions = lgraph.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        KVector calculatedSize = lgraph.getActualSize();
        KVector adjustedSize = new KVector(calculatedSize);
        if (sizeConstraint.contains((Object)SizeConstraint.MINIMUM_SIZE)) {
            KVector minSize = lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
            if (sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minSize.x <= 0.0) {
                    minSize.x = 20.0;
                }
                if (minSize.y <= 0.0) {
                    minSize.y = 20.0;
                }
            }
            adjustedSize.x = Math.max(calculatedSize.x, minSize.x);
            adjustedSize.y = Math.max(calculatedSize.y, minSize.y);
        }
        if (!lgraph.getProperty(LayeredOptions.NODE_SIZE_FIXED_GRAPH_SIZE).booleanValue()) {
            this.resizeGraphNoReallyIMeanIt(lgraph, calculatedSize, adjustedSize);
        }
    }

    private void resizeGraphNoReallyIMeanIt(LGraph lgraph, KVector oldSize, KVector newSize) {
        Set contentAlignment = lgraph.getProperty(LayeredOptions.CONTENT_ALIGNMENT);
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                lgraph.getOffset().x += (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                lgraph.getOffset().x += newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                lgraph.getOffset().y += (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                lgraph.getOffset().y += newSize.y - oldSize.y;
            }
        }
        if (lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS) && (newSize.x > oldSize.x || newSize.y > oldSize.y)) {
            for (LNode node : lgraph.getLayerlessNodes()) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide extPortSide = node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (extPortSide == PortSide.EAST) {
                    node.getPosition().x += newSize.x - oldSize.x;
                    continue;
                }
                if (extPortSide != PortSide.SOUTH) continue;
                node.getPosition().y += newSize.y - oldSize.y;
            }
        }
        LPadding lPadding = lgraph.getPadding();
        lgraph.getSize().x = newSize.x - lPadding.left - lPadding.right;
        lgraph.getSize().y = newSize.y - lPadding.top - lPadding.bottom;
    }

    public static class TestExecutionState {
        private List<LGraph> graphs;
        private int step;

        public List<LGraph> getGraphs() {
            return this.graphs;
        }

        public int getStep() {
            return this.step;
        }
    }
}

