/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered;

import com.modelengineers.MoRe_elk.alg.layered.DotDebugUtil;
import com.modelengineers.MoRe_elk.alg.layered.JsonDebugUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.LoggedGraph;
import java.util.List;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph lgraph, int slotIndex, String name) {
        String tag = String.valueOf(slotIndex) + "-" + name;
        monitor.logGraph(DotDebugUtil.createDebugGraph(lgraph), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(lgraph), tag, LoggedGraph.Type.JSON);
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        String tag = "segment graph";
        monitor.logGraph(DotDebugUtil.createDebugGraph(layeredGraph, segmentList, outgoingList), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(layeredGraph, segmentList, outgoingList), tag, LoggedGraph.Type.JSON);
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph layeredGraph, int layerIndex, List<HyperEdgeSegment> hyperEdgeSegments, String debugPrefix, String label) {
        String tag = String.valueOf(debugPrefix) + " - " + label;
        monitor.logGraph(DotDebugUtil.createDebugGraph(layeredGraph, hyperEdgeSegments), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(layeredGraph, hyperEdgeSegments), tag, LoggedGraph.Type.JSON);
    }
}

