/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.utils;

import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class SVGImage {
    private final double spacing = 20.0;
    private double viewBoxX = Double.POSITIVE_INFINITY;
    private double viewBoxY = Double.POSITIVE_INFINITY;
    private double viewBoxW = 0.0;
    private double viewBoxH = 0.0;
    private double viewBoxX2 = Double.NEGATIVE_INFINITY;
    private double viewBoxY2 = Double.NEGATIVE_INFINITY;
    private boolean enableUpdateViewBox = true;
    private String current = "main";
    private Map<String, String> groups = Maps.newLinkedHashMap();
    public String fileName = null;
    private int index = 0;
    public boolean debug = false;
    public double maxArea = 8294400.0;

    public SVGImage(String file) {
        if (file != null && file.length() > 0 && !file.startsWith("null")) {
            this.fileName = file;
            this.debug = true;
        }
        this.groups.put(this.current, "");
    }

    public SVGImage g(String key) {
        if (this.debug) {
            if (!this.groups.containsKey(key)) {
                this.groups.put(key, "");
            }
            this.current = key;
        }
        return this;
    }

    public void addGroups(String ... keys) {
        if (this.debug) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.groups.put(key, "");
                ++n2;
            }
        }
    }

    public void clearGroup(String key) {
        if (this.debug) {
            this.groups.replace(key, "");
        }
    }

    public void removeGroup(String key) {
        if (this.debug) {
            if (key.equals("main")) {
                this.clearGroup(key);
            } else {
                this.groups.remove(key);
            }
        }
    }

    public void setViewBox(double x, double y, double w, double h) {
        if (this.debug) {
            this.viewBoxX = x;
            this.viewBoxY = y;
            this.viewBoxW = w;
            this.viewBoxH = h;
            this.enableUpdateViewBox = false;
        }
    }

    public void clear() {
        boolean bl = this.debug = this.fileName != null && this.fileName.length() > 0;
        if (this.debug) {
            this.groups.clear();
            this.current = "main";
            this.groups.put(this.current, "");
            if (this.enableUpdateViewBox) {
                this.viewBoxX = Double.POSITIVE_INFINITY;
                this.viewBoxY = Double.POSITIVE_INFINITY;
                this.viewBoxW = 0.0;
                this.viewBoxH = 0.0;
                this.viewBoxX2 = Double.NEGATIVE_INFINITY;
                this.viewBoxY2 = Double.NEGATIVE_INFINITY;
            }
        }
    }

    public void addElementStr(String element) {
        if (this.debug) {
            this.groups.replace(this.current, this.groups.get(this.current).concat(String.valueOf(element) + "\n"));
            this.current = "main";
        }
    }

    public void addCircle(double x, double y) {
        if (this.debug) {
            this.addCircle(x, y, 5.0, "stroke=\"black\" stroke-width=\"1\" fill=\"none\"");
        }
    }

    public void addCircle(double x, double y, double r, String attributes) {
        if (this.debug) {
            this.addElementStr("<circle cx=\"" + x + "\" cy=\"" + y + "\" r=\"" + r + "\" " + attributes + " />");
            this.updateViewBox(new KVector(x - r, y - r), new KVector(x + r, y + r));
        }
    }

    public void addLine(double x1, double y1, double x2, double y2) {
        if (this.debug) {
            this.addLine(x1, y1, x2, y2, "stroke=\"black\" stroke-width=\"1\"");
        }
    }

    public void addLine(double x1, double y1, double x2, double y2, String attributes) {
        if (this.debug) {
            this.addElementStr("<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" " + attributes + " />");
            this.updateViewBox(new KVector(x1, y1), new KVector(x2, y2));
        }
    }

    public void addRect(double x, double y, double w, double h, String attributes) {
        if (this.debug) {
            this.addElementStr("<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + w + "\" height=\"" + h + "\" " + attributes + " />");
            this.updateViewBox(new KVector(x, y), new KVector(x + w, y + h));
        }
    }

    public void addRect(ElkRectangle r, String attributes) {
        if (this.debug) {
            this.addRect(r.x, r.y, r.width, r.height, attributes);
        }
    }

    public void addPoly(String attributes, KVector ... points) {
        if (this.debug) {
            String str = "<polyline points=\"";
            KVector[] kVectorArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                KVector p = kVectorArray[n2];
                str = String.valueOf(str) + p.x + "," + p.y + " ";
                ++n2;
            }
            this.addElementStr(String.valueOf(str) + "\" " + attributes + " />");
            this.updateViewBox(points);
        }
    }

    public void addText(double x, double y, String text, String attributes) {
        if (this.debug) {
            this.addElementStr("<text x=\"" + x + "\" y=\"" + y + "\" " + attributes + ">" + text + "</text>");
        }
    }

    private void updateViewBox(KVector ... points) {
        if (this.debug && this.enableUpdateViewBox) {
            KVector[] kVectorArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                KVector point = kVectorArray[n2];
                if (Double.isFinite(point.x) && Double.isFinite(point.y)) {
                    this.viewBoxX = Math.min(this.viewBoxX, point.x);
                    this.viewBoxY = Math.min(this.viewBoxY, point.y);
                    this.viewBoxX2 = Math.max(this.viewBoxX2, point.x);
                    this.viewBoxY2 = Math.max(this.viewBoxY2, point.y);
                }
                ++n2;
            }
            this.viewBoxW = this.viewBoxX2 - this.viewBoxX;
            this.viewBoxH = this.viewBoxY2 - this.viewBoxY;
        }
    }

    public void save(String fName) {
        if (this.debug) {
            try {
                double area = this.viewBoxH * this.viewBoxW;
                double scale = 1.0;
                if (area > this.maxArea) {
                    scale = Math.sqrt(this.maxArea / area);
                }
                new File(fName).getParentFile().mkdirs();
                PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(fName) + ".svg"));
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.println("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\"  viewBox=\"" + (this.viewBoxX * scale - 20.0) + " " + (this.viewBoxY * scale - 20.0) + " " + (this.viewBoxW * scale + 40.0) + " " + (this.viewBoxH * scale + 40.0) + "\">");
                for (Map.Entry<String, String> entry : this.groups.entrySet()) {
                    out.println("<g transform=\"scale(" + scale + ")\" id=\"" + entry.getKey() + "\">\n" + entry.getValue() + "</g>");
                }
                out.println("</svg>");
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        this.save(this.fileName);
    }

    public void isave(String fName) {
        this.save(String.valueOf(fName) + String.format("%1$03d", this.index));
        ++this.index;
    }

    public void isave() {
        this.isave(this.fileName);
    }
}

