/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.overlaps;

import com.google.common.collect.Sets;
import com.modelengineers.MoRe_elk.alg.common.overlaps.IRectangleStripOverlapRemovalStrategy;
import com.modelengineers.MoRe_elk.alg.common.overlaps.RectangleStripOverlapRemover;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import java.util.HashSet;

public final class GreedyRectangleStripOverlapRemover
implements IRectangleStripOverlapRemovalStrategy {
    @Override
    public double removeOverlaps(RectangleStripOverlapRemover overlapRemover) {
        double verticalGap = overlapRemover.getVerticalGap();
        HashSet alreadyPlacedNodes = Sets.newHashSet();
        double stripSize = 0.0;
        for (RectangleStripOverlapRemover.RectangleNode currNode : overlapRemover.getRectangleNodes()) {
            double yPos = 0.0;
            currNode.getOverlappingNodes().sort(GreedyRectangleStripOverlapRemover::compareByYCoordinate);
            for (RectangleStripOverlapRemover.RectangleNode overlapNode : currNode.getOverlappingNodes()) {
                if (!alreadyPlacedNodes.contains(overlapNode)) continue;
                ElkRectangle currRect = currNode.getRectangle();
                ElkRectangle overlapRect = overlapNode.getRectangle();
                if (!(yPos < overlapRect.y + overlapRect.height + verticalGap) || !(yPos + currRect.height + verticalGap > overlapRect.y)) continue;
                yPos = overlapRect.y + overlapRect.height + verticalGap;
            }
            currNode.getRectangle().y = yPos;
            alreadyPlacedNodes.add(currNode);
            stripSize = Math.max(stripSize, currNode.getRectangle().y + currNode.getRectangle().height);
        }
        return stripSize;
    }

    public static int compareByYCoordinate(RectangleStripOverlapRemover.RectangleNode node1, RectangleStripOverlapRemover.RectangleNode node2) {
        return Double.compare(node1.getRectangle().y, node2.getRectangle().y);
    }
}

