/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.LinearExpr;

public final class WeightedSumExpression
implements LinearExpr {
    private final int[] variablesIndices;
    private final double[] coefficients;
    private final double offset;

    public WeightedSumExpression(int[] variablesIndices, double[] coefficients, double offset) {
        this.variablesIndices = variablesIndices;
        this.coefficients = coefficients;
        this.offset = offset;
    }

    @Override
    public LinearExpr build() {
        return this;
    }

    @Override
    public int numElements() {
        return this.variablesIndices.length;
    }

    @Override
    public int getVariableIndex(int index) {
        if (index < 0 || index >= this.variablesIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getVariable(): " + index);
        }
        return this.variablesIndices[index];
    }

    @Override
    public double getCoefficient(int index) {
        if (index < 0 || index >= this.variablesIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getCoefficient(): " + index);
        }
        return this.coefficients[index];
    }

    @Override
    public double getOffset() {
        return this.offset;
    }
}

