/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.Variable;

public class LinearConstraint {
    private final ModelBuilderHelper helper;
    private final int index;

    public LinearConstraint(ModelBuilderHelper helper) {
        this.helper = helper;
        this.index = helper.addLinearConstraint();
    }

    public int getIndex() {
        return this.index;
    }

    public ModelBuilderHelper getHelper() {
        return this.helper;
    }

    public double getLowerBound() {
        return this.helper.getConstraintLowerBound(this.index);
    }

    public void setLowerBound(double lb) {
        this.helper.setConstraintLowerBound(this.index, lb);
    }

    public double getUpperBound() {
        return this.helper.getConstraintUpperBound(this.index);
    }

    public void setUpperBound(double ub) {
        this.helper.setConstraintUpperBound(this.index, ub);
    }

    public String getName() {
        return this.helper.getConstraintName(this.index);
    }

    public void setName(String name) {
        this.helper.setConstraintName(this.index, name);
    }

    public void addTerm(Variable var, double coeff) {
        this.helper.addConstraintTerm(this.index, var.getIndex(), coeff);
    }

    public LinearConstraint withName(String name) {
        this.setName(name);
        return this;
    }
}

