/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.BoundCost;
import com.google.ortools.constraintsolver.IntIntToLongFunction;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.IntervalVar;
import com.google.ortools.constraintsolver.RoutingModel;
import com.google.ortools.constraintsolver.mainJNI;
import java.util.function.LongBinaryOperator;

public class RoutingDimension {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public RoutingDimension(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(RoutingDimension obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(RoutingDimension obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_RoutingDimension(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public RoutingModel model() {
        long cPtr = mainJNI.RoutingDimension_model(this.swigCPtr, this);
        return cPtr == 0L ? null : new RoutingModel(cPtr, false);
    }

    public long getTransitValue(long from_index, long to_index, long vehicle) {
        return mainJNI.RoutingDimension_getTransitValue(this.swigCPtr, this, from_index, to_index, vehicle);
    }

    public long getTransitValueFromClass(long from_index, long to_index, long vehicle_class) {
        return mainJNI.RoutingDimension_getTransitValueFromClass(this.swigCPtr, this, from_index, to_index, vehicle_class);
    }

    public IntVar cumulVar(long index) {
        long cPtr = mainJNI.RoutingDimension_cumulVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar transitVar(long index) {
        long cPtr = mainJNI.RoutingDimension_transitVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar fixedTransitVar(long index) {
        long cPtr = mainJNI.RoutingDimension_fixedTransitVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar slackVar(long index) {
        long cPtr = mainJNI.RoutingDimension_slackVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar[] cumuls() {
        return mainJNI.RoutingDimension_cumuls(this.swigCPtr, this);
    }

    public IntVar[] fixed_transits() {
        return mainJNI.RoutingDimension_fixed_transits(this.swigCPtr, this);
    }

    public IntVar[] transits() {
        return mainJNI.RoutingDimension_transits(this.swigCPtr, this);
    }

    public IntVar[] slacks() {
        return mainJNI.RoutingDimension_slacks(this.swigCPtr, this);
    }

    public void setSpanUpperBoundForVehicle(long upper_bound, int vehicle) {
        mainJNI.RoutingDimension_setSpanUpperBoundForVehicle(this.swigCPtr, this, upper_bound, vehicle);
    }

    public void setSpanCostCoefficientForVehicle(long coefficient, int vehicle) {
        mainJNI.RoutingDimension_setSpanCostCoefficientForVehicle(this.swigCPtr, this, coefficient, vehicle);
    }

    public void setSpanCostCoefficientForAllVehicles(long coefficient) {
        mainJNI.RoutingDimension_setSpanCostCoefficientForAllVehicles(this.swigCPtr, this, coefficient);
    }

    public void setGlobalSpanCostCoefficient(long coefficient) {
        mainJNI.RoutingDimension_setGlobalSpanCostCoefficient(this.swigCPtr, this, coefficient);
    }

    public void setCumulVarSoftUpperBound(long index, long upper_bound, long coefficient) {
        mainJNI.RoutingDimension_setCumulVarSoftUpperBound(this.swigCPtr, this, index, upper_bound, coefficient);
    }

    public boolean hasCumulVarSoftUpperBound(long index) {
        return mainJNI.RoutingDimension_hasCumulVarSoftUpperBound(this.swigCPtr, this, index);
    }

    public long getCumulVarSoftUpperBound(long index) {
        return mainJNI.RoutingDimension_getCumulVarSoftUpperBound(this.swigCPtr, this, index);
    }

    public long getCumulVarSoftUpperBoundCoefficient(long index) {
        return mainJNI.RoutingDimension_getCumulVarSoftUpperBoundCoefficient(this.swigCPtr, this, index);
    }

    public void setCumulVarSoftLowerBound(long index, long lower_bound, long coefficient) {
        mainJNI.RoutingDimension_setCumulVarSoftLowerBound(this.swigCPtr, this, index, lower_bound, coefficient);
    }

    public boolean hasCumulVarSoftLowerBound(long index) {
        return mainJNI.RoutingDimension_hasCumulVarSoftLowerBound(this.swigCPtr, this, index);
    }

    public long getCumulVarSoftLowerBound(long index) {
        return mainJNI.RoutingDimension_getCumulVarSoftLowerBound(this.swigCPtr, this, index);
    }

    public long getCumulVarSoftLowerBoundCoefficient(long index) {
        return mainJNI.RoutingDimension_getCumulVarSoftLowerBoundCoefficient(this.swigCPtr, this, index);
    }

    public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, int pre_travel_evaluator, int post_travel_evaluator) {
        mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_0(this.swigCPtr, this, breaks, vehicle, pre_travel_evaluator, post_travel_evaluator);
    }

    public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, long[] node_visit_transits) {
        mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_1(this.swigCPtr, this, breaks, vehicle, node_visit_transits);
    }

    public void setBreakDistanceDurationOfVehicle(long distance, long duration, int vehicle) {
        mainJNI.RoutingDimension_setBreakDistanceDurationOfVehicle(this.swigCPtr, this, distance, duration, vehicle);
    }

    public void InitializeBreaks() {
        mainJNI.RoutingDimension_InitializeBreaks(this.swigCPtr, this);
    }

    public boolean HasBreakConstraints() {
        return mainJNI.RoutingDimension_HasBreakConstraints(this.swigCPtr, this);
    }

    public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, long[] node_visit_transits, LongBinaryOperator delays) {
        mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_2(this.swigCPtr, this, breaks, vehicle, node_visit_transits, delays);
    }

    public IntervalVar[] getBreakIntervalsOfVehicle(int vehicle) {
        return mainJNI.RoutingDimension_getBreakIntervalsOfVehicle(this.swigCPtr, this, vehicle);
    }

    public int GetPreTravelEvaluatorOfVehicle(int vehicle) {
        return mainJNI.RoutingDimension_GetPreTravelEvaluatorOfVehicle(this.swigCPtr, this, vehicle);
    }

    public int GetPostTravelEvaluatorOfVehicle(int vehicle) {
        return mainJNI.RoutingDimension_GetPostTravelEvaluatorOfVehicle(this.swigCPtr, this, vehicle);
    }

    public RoutingDimension base_dimension() {
        long cPtr = mainJNI.RoutingDimension_base_dimension(this.swigCPtr, this);
        return cPtr == 0L ? null : new RoutingDimension(cPtr, false);
    }

    public long shortestTransitionSlack(long node) {
        return mainJNI.RoutingDimension_shortestTransitionSlack(this.swigCPtr, this, node);
    }

    public String name() {
        return mainJNI.RoutingDimension_name(this.swigCPtr, this);
    }

    public void setPickupToDeliveryLimitFunctionForPair(IntIntToLongFunction limit_function, int pair_index) {
        mainJNI.RoutingDimension_setPickupToDeliveryLimitFunctionForPair(this.swigCPtr, this, limit_function, pair_index);
    }

    public boolean hasPickupToDeliveryLimits() {
        return mainJNI.RoutingDimension_hasPickupToDeliveryLimits(this.swigCPtr, this);
    }

    public void addNodePrecedence(long first_node, long second_node, long offset) {
        mainJNI.RoutingDimension_addNodePrecedence(this.swigCPtr, this, first_node, second_node, offset);
    }

    public long getSpanUpperBoundForVehicle(int vehicle) {
        return mainJNI.RoutingDimension_getSpanUpperBoundForVehicle(this.swigCPtr, this, vehicle);
    }

    public long getSpanCostCoefficientForVehicle(int vehicle) {
        return mainJNI.RoutingDimension_getSpanCostCoefficientForVehicle(this.swigCPtr, this, vehicle);
    }

    public long getGlobalSpanCostCoefficient() {
        return mainJNI.RoutingDimension_getGlobalSpanCostCoefficient(this.swigCPtr, this);
    }

    public long GetGlobalOptimizerOffset() {
        return mainJNI.RoutingDimension_GetGlobalOptimizerOffset(this.swigCPtr, this);
    }

    public long getLocalOptimizerOffsetForVehicle(int vehicle) {
        return mainJNI.RoutingDimension_getLocalOptimizerOffsetForVehicle(this.swigCPtr, this, vehicle);
    }

    public void setSoftSpanUpperBoundForVehicle(BoundCost bound_cost, int vehicle) {
        mainJNI.RoutingDimension_setSoftSpanUpperBoundForVehicle(this.swigCPtr, this, BoundCost.getCPtr(bound_cost), bound_cost, vehicle);
    }

    public boolean hasSoftSpanUpperBounds() {
        return mainJNI.RoutingDimension_hasSoftSpanUpperBounds(this.swigCPtr, this);
    }

    public BoundCost getSoftSpanUpperBoundForVehicle(int vehicle) {
        return new BoundCost(mainJNI.RoutingDimension_getSoftSpanUpperBoundForVehicle(this.swigCPtr, this, vehicle), true);
    }

    public void setQuadraticCostSoftSpanUpperBoundForVehicle(BoundCost bound_cost, int vehicle) {
        mainJNI.RoutingDimension_setQuadraticCostSoftSpanUpperBoundForVehicle(this.swigCPtr, this, BoundCost.getCPtr(bound_cost), bound_cost, vehicle);
    }

    public boolean hasQuadraticCostSoftSpanUpperBounds() {
        return mainJNI.RoutingDimension_hasQuadraticCostSoftSpanUpperBounds(this.swigCPtr, this);
    }

    public BoundCost getQuadraticCostSoftSpanUpperBoundForVehicle(int vehicle) {
        return new BoundCost(mainJNI.RoutingDimension_getQuadraticCostSoftSpanUpperBoundForVehicle(this.swigCPtr, this, vehicle), true);
    }
}

